<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2008-2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2008, Stéphane Graber <stgraber@ubuntu.com>
 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    # Set the document's charset
    header('Content-type: text/html; charset=utf-8');

    # Setup gettext
    setlocale(LC_ALL, "fr_CA.UTF-8"); #FIXME: Need real handling of locales
    bindtextdomain("ltsp-cluster-control","./po/");
    bind_textdomain_codeset("ltsp-cluster-control","utf-8");
    textdomain("ltsp-cluster-control");

    #FIXME: A configuration file should be used instead.
    $config['theme'] = "ubuntu";
    $config['defaultpage'] = "summary";

    # Set the URL prefix based on current URL and rewriting settings
    if ($config['url_rewriting'] == "1") {
        ereg("(.*)/index.*",$_SERVER["SCRIPT_NAME"],$url);
        $url_prefix=$url[1]."/";
    }
    else {
        $url_prefix=$_SERVER["SCRIPT_NAME"]."?page=";
    }

    # Load the base functions
    include "includes/menu.php";
    include "themes/engine.php";

    # Check and parse the query (GET)
    if ($_GET['q']) {
        $current_page=$_GET['q'];
    }
    else {
        $current_page=Null;
    }

    # Add stock categories
    menuAddCategory(_("Monitoring"),0);
    menuAddCategory(_("Administration"),1);

    # Load the modules
    include "modules/loadbalancer.data.php";
    include "modules/appservers.page.php";

    $page = array();
    $page['title'] = _("LTSP-Cluster Control Center");
    if ($current_page) {
        $page['content'] = call_user_func($current_page."_main");
    }
    else {
        $page['content'] = "empty";
    }
    $page['footer'] = "Copyright &copy; 2008-2009 Revolution Linux Inc.";

    print renderPage($page,$menu);
?>
