-- vim:sw=4:sts=4

-- This file is loaded at startup by libluagtk2 and contains overrides for
-- gtk functions otherwise awkward to call.  I think it is preferable to
-- write these overrides in Lua than in C to keep the C codebase small.

-- these are stored as upvalues in the environment
local table = table
local base = _G
local select = select
module "gtk"


---
-- Append an item to a tree store.
--
-- @param store     The store to add to
-- @param iter      Iterator to be set to the new item; can be nil, it will
--		    be allocated automatically in this case.
-- @param parent    Iterator pointing to the parent, or nil
-- @param ...       Values for all of the columns
--
-- Note: works around the strange (clever?) vararg workaround
--
function gtk_tree_store_append1(store, iter, parent, ...)
    iter = iter or new "GtkTreeIter"
    __gtk_tree_store_append(store, iter, parent)
    local args, i, arg_n = { iter }
    local pos = 2
    for i = 1, select('#', ...) do
	table.insert(args, pos, i - 1)
	arg_n = select(i, ...)
	table.insert(args, pos + 1, arg_n)
	pos = pos + 2
    end
    table.insert(args, pos, -1)
    store:set(base.unpack(args))
    return iter
end

---
-- Same as gtk_tree_store_append1, but without the parent
--
function gtk_list_store_append1(store, iter, ...)
    iter = iter or new "GtkTreeIter"
    __gtk_list_store_append(store, iter)
    local args, i, arg_n = { iter }
    local pos = 2	-- table.insert with pos to handle nil values
    for i = 1, select('#', ...) do
	table.insert(args, pos, i - 1)
	arg_n = select(i, ...)
	table.insert(args, pos + 1, arg_n)
	pos = pos + 2
    end
    table.insert(args, pos, -1)
    store:set(base.unpack(args))
    return iter
end

---
-- Insert a string at the current cursor position.
--
-- Avoid having to specify the length.
--
function gtk_text_buffer_insert_at_cursor(buffer, text)
    __gtk_text_buffer_insert_at_cursor(buffer, text, #text)
end

function gtk_text_buffer_insert(buffer, iter, text)
    __gtk_text_buffer_insert(buffer, iter, text, #text)
end

-- atypical name
function pango_layout_get_clip_region(...)
    return __gdk_pango_layout_get_clip_region(...)
end

