local lpeg = require "lpeg"

describe("Email Addresses", function()
	local email = require "lpeg_patterns.email".email * lpeg.P(-1)
	it("Pass valid addresses", function()
		assert.truthy ( email:match( "localpart@example.com" ) )
	end)
	it("Deny invalid addresses", function()
		assert.falsy ( email:match( "not an address" ) )
	end)
	it("Handle unusual localpart", function()
		assert.truthy ( email:match "foo.bar@example.com" )
		assert.truthy ( email:match "foo+@example.com" )
		assert.truthy ( email:match "foo+bar@example.com" )
		assert.truthy ( email:match "!#$%&'*+-/=?^_`{}|~@example.com" )
		assert.truthy ( email:match [["quoted"@example.com]] )
		assert.truthy ( email:match [["quoted string"@example.com]] )
		assert.truthy ( email:match [["quoted@symbol"@example.com]] )
		assert.truthy ( email:match [=["very.(),:;<>[]\".VERY.\"very@\\ \"very\".unusual"@example.com]=] )
	end)
	it("Ignore invalid localpart", function()
		assert.falsy ( email:match "@example.com" )
		assert.falsy ( email:match ".@example.com" )
		assert.falsy ( email:match "foobar.@example.com" )
		assert.falsy ( email:match "@foo@example.com" )
		assert.falsy ( email:match "foo@bar@example.com" )
		assert.falsy ( email:match [[just"not"right@example.com]] ) -- quoted strings must be dot separated, or the only element making up the local-part
		assert.falsy ( email:match( "\127@example.com" ) )
	end)
	it("Handle unusual hosts", function()
		assert.truthy ( email:match "localpart@host_name" )
		assert.truthy ( email:match "localpart@[127.0.0.1]" )
		assert.truthy ( email:match "localpart@[IPv6:2001::d1]" )
		assert.truthy ( email:match "localpart@[::1]" )
	end)
	it("Handle comments", function()
		assert.truthy ( email:match "localpart@(comment)example.com" )
		assert.truthy ( email:match "localpart@example.com(comment)" )
	end)
end)
