/* ---------------------------------- about.cpp ---------------------------------------------------------------------------
 Class to display the about dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 23 May 2009
===============================================================================================================================
===============================================================================================================================
*/
#include "about.h"

// class aboutDialog Constructor=================================================================================================
// Displays a simple about dialog
aboutDialog::aboutDialog (QUrl licenseUrl, QDialog *parent) : QDialog (parent)
{
	uiA.setupUi(this);
	//connect okay pushButton SLOTs ----------------
	connect ( uiA.pushButton_ok, SIGNAL( clicked() ), this, SLOT( okay() ) );

	setTop();
	setAbout();
	setAuthor();
	setThanks();
	setLicense(licenseUrl);
}
// SLOTS-------------------------------------------------------------------------------------
// --------------------------------okay pressed------------------------------------------------
void aboutDialog::okay()
{
	close();
}

// FUNCTIONS-------------------------------------------------------------------------------------
void aboutDialog::setTop()
{
	Text = appName+" "+ countStr.setNum(appVersion);
	uiA.label_Top -> setText(Text);
}
void aboutDialog::setAbout()
{
	uiA.textBrowser_About -> setOpenLinks(TRUE);
	uiA.textBrowser_About -> setOpenExternalLinks(TRUE);

	Text = 	"<p align=\"center\"><b>"+appName + " " + countStr.setNum(appVersion) +"</b> ("+
		tr("using Qt4")+")" + "<br>" +
		tr("Backup & Sync Application")+"<br><br>"

		"(C) 2008-2009,	"+
		tr("Loukas Avgeriou") +"<br><br>"

		"web:<br>"
		"<a href=\"http://luckybackup.sourceforge.net/\" target=\"_blank\">http://luckybackup.sourceforge.net/</a> <br>"
		"<a href=\"http://www.kde-apps.org/content/show.php/luckyBackup?content=94391\" target=\"_blank\">http://www.kde-apps.org/</a> <br><br>"

		"<a href=\"http://www.gnu.org/copyleft/gpl.html\" target=\"_blank\"><img name=\"gpl\""
		" src=\":/luckyPrefix/gplv3-127x51.png\" width=\"60\" height=\"20\" border=\"0\"></a>&nbsp;&nbsp;"+
		tr("luckyBackup is distributed under the terms of the")+
		" <a href=\"http://www.gnu.org/copyleft/gpl.html\" target=\"_blank\">" +
		tr("GNU General Public License")+".</a>" +"<br><br>" +

		tr("It is <b>free software</b>: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 3 of the License.") +"<br>" +
		tr("It is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.")+ "<br>" +
		tr("See the 'License Agreement' tab for more details.")+"</p>";

	uiA.textBrowser_About -> setText(Text);
}
void aboutDialog::setAuthor()
{
	uiA.textBrowser_Author -> setOpenLinks(TRUE);
	uiA.textBrowser_Author -> setOpenExternalLinks(TRUE);

	Text =	"<p align=\"center\"><br><img name=\"luckyb\" src=\":/luckyPrefix/luckyb.png\" width=\"80\" height=\"80\" border=\"0\"><b><br><br>"+
		tr("Loukas Avgeriou") +"</b> (luckyb)<br>"+
		tr("Athens, Greece") +
		"<br><br><a href=\"mailto:luckyb69@users.sourceforge.net\">luckyb69@users.sourceforge.net</a></p>";
	uiA.textBrowser_Author -> setText(Text);
}
void aboutDialog::setThanks()
{
	uiA.textBrowser_Thanks -> setOpenLinks(TRUE);
	uiA.textBrowser_Thanks -> setOpenExternalLinks(TRUE);

	Text =	"<p align=\"center\"><b>" + tr("Tom Tryfonidis") + "</b><br>(thanos)<br>" +
		tr("Arch linux package/pkgbuild official maintainer (AUR)") + "<br><br>"

		"<b>" + tr("Yiorgos Kapellakis") + "</b><br>(slackware)<br>" +
		tr("rpm packager, valuable tester and remote connections advisor") + "<br><br>"

		"<b>" + tr("Patrick Matthaei") + "</b><br>(Debian Developer)<br>" +
		tr("Debian package maintainer") + "<br><br>"
		
		"<b>" + tr("Nikolas Poniros") + "</b><br>(edhunter)<br>" +
		tr("Greek gui translator and valuable tester") + "<br><br>"

		"<b>" + tr("Stephan Kleine") + "</b><br>" +
		tr("OpenSUSE package maintainer (KDE4 Community repo) and valuable packing advisor") + "<br><br>"

		"<b>" + tr("Marcos Del Puerto Garcia") + "</b><br>" +
		tr("Mepis package maintainer (Community repo) & Spanish gui translator") + "<br><br>"

		"<b>" + tr("Savvas Radevic") + "</b><br>" +
		tr("ubuntu package maintainer (launchpad PPA)") + "<br><br>"

		"<b>" + tr("Jack Fink") + "</b><br>" +
		tr("port to Mac OS X") + "<br><br>"

		"<b>" + tr("Theo Chatzimichos") + "</b><br>" +
		tr("Gentoo ebuild maintainer") + "<br><br>"

		"<b>" + tr("Pavel Fric") + "</b><br>" +
		tr("Czech gui translator") + "<br><br>"

		"<b>" + tr("Wilfried Schobel") + "</b><br>" +
		tr("German gui translator") + "<br><br>"

		"<b>" + tr("Sergio Gameiro") + "</b><br>" +
		tr("Portuguese gui translator") + "<br><br>"

		"<b>" + tr("Marcio Moraes") + "</b><br>" +
		tr("Portuguese gui translator") + "<br><br>"

		"<b>" + tr("Julien Cynober") + "</b><br>" +
		tr("French gui translator and valuable packing advisor (and not only)") + "<br><br>"

		"<b>" + tr("Denis Skorski") + "</b><br>" +
		tr("Russian gui translator and valuable tester") + "<br><br>"

		"<b>" + tr("Kenny Verstraete") + "</b><br>" +
		tr("Dutch gui translator") + "<br><br>"
		
		"<b>" + tr("Javi Romero") + "</b><br>" +
		tr("v0.3 gui designer") + "<br><br>"

		"<b>" + tr("fri13") + "</b><br>" +
		tr("v.0.3 gui designer") + "<br><br>"

		"<b>" + tr("Dimitris Kalamaras") + "</b><br>(dimitris)<br>" +
		tr("If it wasn't him and his tutorials I would never have started this project") + "<br><br>" + 

		tr("...to all users of the ")+
		"<br><a href=\"http://www.linuxformat.gr/\" target=\"_blank\">Hellenic Linuxformat</a>, "
		"<a href=\"http://www.sidux.com/\" target=\"_blank\">sidux.com</a>, "
		"<a href=\"http://www.sidux.gr/\" target=\"_blank\">sidux.gr</a>, "
		"<a href=\"http://forum.ubuntu-gr.org/\" target=\"_blank\">ubuntu.gr</a> "
		"and <a href=\"http://www.kde-apps.org//\" target=\"_blank\">kde-apps.org</a><br>" +
		tr("forums for their support.") + "<br><br>" +
		tr("Especially") + "<br><b>alfisti, constantinos, promeneur, grigris, dannys,marios, Regenwald, flo, Ilias Paraponiaris, Takis Vounatsos, Lieven Tytgat, mathetes, Johan Linde, Chris Sylvester, Manos Nikiforakis, Giorgos Katsikatsos, Carsten, Ray Ambrosi, Barry Jackson and Chris (slam)</b><br>" +
		tr("that contributed to this project one way or another") + "<br><br>" +

		tr("Last but no least") +":<br>"+
		tr("...my other half, <b>Dimitra</b> that bares with me all these times that this project is under development") + " :-)<br></p>";
	uiA.textBrowser_Thanks-> setText(Text);;
}
void aboutDialog::setLicense(QUrl licenseUrl)
{
	uiA.textBrowser_License -> setOpenLinks(TRUE);
	uiA.textBrowser_License -> setOpenExternalLinks(TRUE);

	licenseUrl.setScheme("file");

	if (licenseUrl.toString() == "file:///Does_not_exist")
		uiA.textBrowser_License -> setText(tr("Could not locate the license file") + "!!");
	else
		uiA.textBrowser_License -> setSource(licenseUrl);

}
// end of about.cpp ---------------------------------------------------------------------------

