/*-------------------------main.cpp------------------------------------------
 Main project is "luckyBackup"
 a backup and sync tool
 project version	: 0.3

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 developer 		: luckyb 
 last modified 		: 04 May 2009
===============================================================================================================================
===============================================================================================================================
*/

// just include the qt libraries needed, the main window header file
// and show the main window or execute in command line mode

#include <QApplication>
#include <QTranslator>

#include "luckybackupwindow.h"
#include "commandline.cpp"

int main(int argc, char *argv[])
{

	if (argc == 1)	//if no arguments are given execute gui
	{
		QApplication app(argc, argv);

		//translation
		QString locale = QLocale::system().name();
		transDir.setPath(relativeTransDir);
		if (transDir.exists())
			appTranslator.load(QString("luckybackup_") + locale, relativeTransDir);
		else 
			appTranslator.load(QString("luckybackup_") + locale, systemTransDir);
		app.installTranslator(&appTranslator);

		luckyBackupWindow luckybackup;
		luckybackup.show();
		return app.exec();
	}

	//execute luckybackup in console mode
	commandline commandLine;
	if (commandLine.argsTest(argc,argv))		//test for correct arguments
		return commandLine.result();		//then execute anything necessary
	return 1;
} 

// end of main.cpp---------------------------------------------------------
