/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : lconf.h
 * Description : Level configuration file parsing
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef L_LCONF_H
#define L_LCONF_H

#include <SDL.h>

typedef enum {LuolaLevel,Luola8bitLevel} LevelType;

typedef struct _LevelBgMusic {
  char *file;
  struct _LevelBgMusic *next;
} LevelBgMusic;

/* Main block */
typedef struct {
  char modified[12];
  char *artwork;
  char *collmap;
  char *name;
  LevelType type;
  Uint8 scalex;
  Uint8 scaley;
  Uint8 smooth_scale;
  LevelBgMusic *music;
} LSB_Main;

/* Override block */
typedef struct {
  Uint8 indstr_base;
  Uint8 critters_enabled;
  Uint8 stars;
  Uint8 snowfall;
  Uint8 turrets;
  Uint8 jumpgates;
  Uint8 cows;
  Uint8 fish;
  Uint8 birds;
  Uint8 bats;
  Uint8 soldiers;
  Uint8 helicopters;
} LSB_Override;

/* Objects block */
typedef struct LSB_Objects {
  Uint8 type;
  int x,y;
  Uint8 ceiling_attach;
  Uint8 value;
  Uint32 id,link;
  struct LSB_Objects *next;
} LSB_Objects;

/* Palette block */
typedef struct {
  Uint8 entries[256];
} LSB_Palette;

/* Level settings structure */
typedef struct {
  LSB_Main *mainblock;
  LSB_Override *override;
  LSB_Objects *objects;
  LSB_Palette *palette;
  SDL_Surface *icon;
} LevelSettings;

/* Just the settings needed to display a level */
typedef struct {
  LSB_Main *mainblock;
  SDL_Surface *icon;
} LevelInfo;

/* Load a text mode configuration file */
LevelSettings *load_level_config(const char *filename,int loadextra);

/* Load a binary configuration file */
LevelSettings *load_level_config_rw(SDL_RWops *rw,int len);

/* Get the important parts of a text mode configuration file */
LevelInfo *quickload_levelsettings(const char *filename);

/* Load just the main block from a binary configuration file */
LevelInfo *quickload_levelsettings_rw(SDL_RWops *rw,int len);

#endif
