/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : main.c
 * Description : Main module
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <string.h>

#include "defines.h"
#include "fs.h"
#include "console.h"
#include "intro.h"
#include "game.h"
#include "levelfile.h"
#include "hotseat.h"
#include "level.h"
#include "player.h"
#include "particle.h"
#include "weapon.h"
#include "animation.h"
#include "special.h"
#include "critter.h"
#include "weather.h"
#include "font.h"
#include "demo.h"
#include "startup.h"

#if HAVE_LIBSDL_MIXER
#include "audio.h"
#endif

#ifdef ENABLE_NLS
#include <locale.h>
#endif

static void show_version(void);

int main(int argc,char *argv[]) {
int rval,r;
/* Parse command line arguments */
init_startup_options();
#ifdef CHEAT_POSSIBLE
cheat=0;
#endif
if(argc>1) {
  for(r=1;r<argc;r++) {
    if(strcmp(argv[r],"--help")==0) {
      print_help();
      return 0;
    } else if(strcmp(argv[r],"--version")==0) show_version();
#ifdef CHEAT_POSSIBLE
    else if(strcmp(argv[r],"--cheat")==0) {
      cheat=1; cheat1=0;
      printf("Cheat er.. Debug mode enabled\n");
    }
#endif
    else if((r=parse_argument(r,argc,argv))==0) return 0;
  }
}
/* Check if luola's home directory exists */
check_homedir();
/* Seed the random number generator */
srand(time(NULL));
/* Set locale */
#ifdef ENABLE_NLS
if(setlocale(LC_MESSAGES,luola_options.lang)==NULL) {
  if(strlen(luola_options.lang)) printf("Locale \"%s\" could not be initialized.\nCheck if this locale is supported by running locale -a.\n",luola_options.lang);
}
bindtextdomain(PACKAGE,PACKAGE_LOCALE_DIR);
textdomain(PACKAGE);
#endif
/* Initialize */
init_sdl();
init_video();
#if HAVE_LIBSDL_MIXER
if(luola_options.sounds)
  init_audio();
#endif
init_font();
init_level();
init_particles();
init_game();
init_weapons();
init_intro();
init_players();
init_ships();
init_pilots();
init_hotseat();
init_specials();
init_critters();
init_weather();
if(luola_options.mbg_anim) init_demos();
scan_levels(0);
scan_levels(1);
if(game_settings.levels==NULL) no_levels_found();
load_game_config();
while(1) {
  /* Intro screen */
  rval=game_menu_screen();
  if(rval==INTRO_RVAL_EXIT) return 0;
  /* Play ! */
  if(rval==INTRO_RVAL_STARTGAME) hotseat_game();
}
return 0;
}

static void show_version(void) {
  const SDL_version *sdld;
  const SDL_VideoInfo *vidinfo;
  SDL_Init(SDL_INIT_VIDEO); /* So we get info about the video mode */
  sdld=SDL_Linked_Version();
  vidinfo=SDL_GetVideoInfo();
  printf("%s version %s (Stable branch)\n",PACKAGE,VERSION);
  printf("Compiled with SDL version %d.%d.%d\n",SDL_MAJOR_VERSION,SDL_MINOR_VERSION,SDL_PATCHLEVEL);
  printf("Dynamically linked SDL version is %d.%d.%d\n",sdld->major,sdld->minor,sdld->patch);
#ifdef PACKAGE_DATA_DIR
  printf("Data directory is \"%s\"\n",PACKAGE_DATA_DIR);
#else
  printf("Test compile, data directory is \"../data\"\n");
#endif
  printf("\nCompiled in features:\n");
#if HAVE_LIBSDL_MIXER
  printf("SDL_Mixer (sounds): enabled\n");
#else
  printf("SDL_Mixer (sounds): disabled\n");
#endif
#if HAVE_LIBSDL_GFX
  printf("SDL_gfx (eyecandy): enabled\n");
#else
  printf("SDL_gfx (eyecandy): disabled\n");
#endif
#if HAVE_LIBSDL_TTF
  printf("SDL_ttf (Truetype fonts): enabled\n");
#else
  printf("SDL_ttf (Truetype fonts): disabled\n");
#endif
#ifdef ENABLE_NLS
  printf("Internationalization: enabled\n");
  printf("Available languages: %s\n",SUPPORTED_LANGUAGES);
  printf("Locale directory: %s\n",PACKAGE_LOCALE_DIR);
#else
  printf("Internationalization: disabled\n");
#endif
  if(vidinfo) {
    printf("Video information:\n");
    printf("Hardware surfaces available: %s\n",vidinfo->hw_available?"yes":"no");
    printf("Hardware accelerated blits: %s\n",vidinfo->blit_hw?"yes":"no");
    printf("Hardware accelerated blits with colorkey: %s\n",vidinfo->blit_hw_CC?"yes":"no");
    printf("Hardware accelerated blits with alpha: %s\n",vidinfo->blit_hw_A?"yes":"no");
    printf("Accelerated sw->hw blits: %s\n",vidinfo->blit_sw?"yes":"no");
    printf("Accelerated sw->hw blits with colorkey: %s\n",vidinfo->blit_sw_CC?"yes":"no");
    printf("Accelerated sw->hw blits with alpha: %s\n",vidinfo->blit_sw_A?"yes":"no");
    printf("Total ammount of video memory: %d kilobytes\n",vidinfo->video_mem);
    printf("Best mode has %d bits per pixel\n",vidinfo->vfmt->BitsPerPixel);
  }
  printf("\nAuthor: Calle Laakkonen\n");
  printf("Homepage: http://www.saunalahti.fi/~laakkon1/linux/luola/index.php\n");
  printf("Contributors:\n");
  printf("Mads Villadsen\n");
  printf("Pauli Virtanen\n");
  printf("Eero Tamminen\n");
  exit(0);
}


