/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : stringutil.c
 * Description : Miscallenous string operations
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <SDL_keysym.h>

#include "defines.h"
#include "game.h"
#include "weapon.h"
#include "stringutil.h"

/* actually strips all characters upto 0x20, \r, \n, \t... */
char *strip_white_space(const char *str) {
  int len;
  char *newstr=NULL;
  const char *s1,*s2;
  s1=str;
  s2=str+strlen(str)-1;
  while(s1<s2 && (*s1<=' ')) s1++;
  while(s2>=s1 && (*s2<=' ')) s2--;
  s2++;
  len=s2-s1;
  if(len<=0) return NULL;
  newstr=(char*)malloc(sizeof(char)*(len+1));
  if(newstr==NULL) {
    printf("Malloc error at strip_white_space ! (attempted to allocate %d bytes\n",len);
    exit(1);
  }
  strncpy(newstr,s1,len);
  newstr[len]='\0';
  return newstr;
}

int split_string(char *str,char delim,char **left,char **right) {
  int l1;
  char *tl=NULL,*tr=NULL;
  l1=strchr(str,delim)-str;
  tl=malloc(l1+1);
  strncpy(tl,str,l1);
  tl[l1]=0;
  tr=malloc(strlen(str)-l1);
  strcpy(tr,str+l1+1);
  
  *left=strip_white_space(tl);
  *right=strip_white_space(tr);
  free(tl);
  free(tr);
  return 0;
}

char *controller_name(int type) {
  switch(type) {
    case Keyboard: return _("Keyboard");
    case Pad1: return _("Pad 1");
    case Pad2: return _("Pad 2");
    case Pad3: return _("Pad 3");
    case Pad4: return _("Pad 4");
    default: return "huh ?";
  }
}

char *weap2str(int weapon) {
  switch(weapon) {
    case WCannon: return _("Cannon"); /* This is the ordinary weapon, it should newer get here */
    case WGrenade: return _("Grenade");
    case WMegaBomb: return _("Mega bomb");
    case WMissile: return _("Homing missile");
    case WCloak: return _("Cloaking device");
    case WMagMine: return _("Magnetic mine");
    case WMine: return _("Mine");
    case WShield: return _("Shield");
    case WGhostShip: return _("Ghost Ship");
    case WAfterBurner: return _("After Burner");
    case WWarp: return _("Jump engine");
    case WClaybomb: return _("Claybomb");
    case WPlastique: return _("Plastic explosive");
    case WSnowball: return _("Snowball");
    case WDart: return _("Dart");
    case WLandmine: return _("Landmine");
    case WRepair: return _("Autorepair system");
    case WInfantry: return _("Infantry");
    case WHelicopter: return _("Helicopter");
    case WSpeargun: return _("Speargun");
    case WGravGun: return _("Grav-gun");
    case WGravMine: return _("Gravity mine");
    case WZapper: return _("Thunderbolt");
    case WShotgun: return _("Shotgun");
    case WRocket: return _("Rocket");
    case WEnergy: return _("Microwave cannon");
    case WBoomerang: return _("Boomerang bomb");
    case WRemote: return _("Remote control");
    case WDivide: return _("Dividing mine");
    case WTag: return _("Tag-gun");
    case WMush: return _("Mush");
    case WWatergun: return _("Watergun");
    case WEmber: return _("Ember");
    case WAcid: return _("Acid");
    case WMirv: return _("MIRV");
    case WFlame: return _("Flamethrower");
    case WEMP: return _("EMP");
    case WAntigrav: return _("Gravity coil");
    default: return "BFG-9000";
  }
}

char *sweap2str(int weapon) {
  switch(weapon) {
    case SShot: return _("Cannon");
    case S3ShotWide: return _("Wide triple shot");
    case S3ShotTight: return _("Tight triple shot");
    case SSweep: return _("Sweeping shots");
    case S4Way: return _("4 Way");
    default: return "BFG-8900";
  }
}

char *critical2str(int critical) {
  switch(critical) {
    case CRITICAL_ENGINE: return _("Critical engine core");
    case CRITICAL_FUELCONTROL: return _("Critical fuel control");
    case CRITICAL_LTHRUSTER: return _("Critical left thruster");
    case CRITICAL_RTHRUSTER: return _("Critical right thruster");
    case CRITICAL_CARGO: return _("Critical cargo hold");
    case CRITICAL_STDWEAPON: return _("Critical mainweapon");
    case CRITICAL_SPECIAL: return _("Critical special weapon");
    default: return "Critical FOO";
  }
}
