//
//  Lynkeos
//  $Id: MyImageView.h,v 1.4 2004/09/02 22:41:58 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Wed Sep 24 2003.
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYIMAGEVIEW_H
#define __MYIMAGEVIEW_H

#ifdef GNUSTEP
#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "LynkeosCommon.h"
#else
#import <Cocoa/Cocoa.h>
#endif

typedef enum { SelNone, SelNormal, SelH, SelV, SelMove } MySelectingMode;

@interface MyImageView : NSView
{
@private
    // For IB
    IBOutlet NSSlider* _zoomSlider;
    IBOutlet NSTextField* _zoomField;
    IBOutlet id _delegate;

    // Image management
    NSPoint             _offset;
    NSImageRep*         _imageRep;
    NSSize              _imageSize;
    // Zoom control
    double              _zoom;
    // Selection management
    bool                _resizable;
    MyIntegerPoint      _selectionOrigin, _lastPoint;
    MyIntegerRect       _selection;
    NSCursor            *_crossCursor,					// Cursors
                        *_leftCursor, *_rightCursor, *_topCursor, *_bottomCursor, *_topLeftCursor,
                        *_topRightCursor, *_bottomLeftCursor, *_bottomRightCursor, *_insideCursor;
    NSRect              _left, _right, _top, _bottom, _topLeft,		// Cursor rectangles
                        _topRight, _bottomLeft, _bottomRight, _inside;
    MySelectingMode _selectMode;
}

// Interface builder stuff
- (IBAction)doZoom:(id)sender;
- (IBAction)moreZoom:(id)sender;
- (IBAction)lessZoom:(id)sender;

// Image
- (void) setImage :(NSImage*)image offset:(NSPoint)offset ;
- (NSSize) imageSize ;
@end

@interface MyImageView(Selection)
// Cursors
- (void) initCursors ;
// Selections handling
- (MyIntegerRect) getSelection ;
- (void) setSelection :(MyIntegerRect)selection resizable:(bool)resize;
@end

@protocol MyImageViewDelegate
- (void) myImageView :(MyImageView*)imageView selectionRectDidChange :(MyIntegerRect)rect :(unsigned int)modifier ;
@end

#endif
