/*
 *  do-printf.h
 */


#ifndef  DO_PRINTF_H_INCLUDED__
#define  DO_PRINTF_H_INCLUDED__

#include <stdarg.h>
#include <stdio.h>

typedef		int (* putc_fun_T) (int ch, void *stream);

extern int
do_printf (putc_fun_T	   pr_chr,
	   const char	 * fmt0,
	   va_list	   argp,
	   void		 * stream);


/* Local hacks for extending printf() &co */

typedef	    int	 (* printf_handler) (va_list	 * arg_p,
				     putc_fun_T	   putc_func,
				     char	   sign,
				     int	   flags,
				     int	   width,
				     int	   precision,
				     void	 * stream);

#define	PRINTF_LONGINT		0x01	/* long integer, 'l' */
#define	PRINTF_LONGDBL		0x02	/* long double, 'L'; unimplemented */
#define	PRINTF_SHORTINT		0x04	/* short integer, 'h' */
#define	PRINTF_ALT		0x08	/* alternate form, '#' */
#define	PRINTF_LADJUST		0x10	/* left adjustment */
#define	PRINTF_ZEROPAD		0x20	/* zero (as opposed to blank) pad */


/*
 *  The new handler function NEW_HANDLER should take the following six
 *  parameters:
 *  1.	A pointer to a va_list
 *  2.	A pointer to a function that should be called to print out
 *	each character.  It should should be called with
 *  3.	A sign flag, which holds any of the characters '\0', '-',
 *	'+' or ' ', depending on which modifiers were present.
 *  4.	Some flags as above.
 *  5.	The width given in the format (e g %8d), or 0 if none.
 *  6.  The precision given in the format (e g %.3d), or -1 if none.
 *  The handler should return the number of characters written, or -1
 *  if any error occured.
 *  If the handler is NULL, then the default behaviour is reinstated.
 */
printf_handler
extend_printf (unsigned char	format_char,
	       printf_handler	new_handler );


#endif  /* DO_PRINTF_H_INCLUDED__ */
