/*
 *  client/read-line.c
 *		Routines to read one line from file.
 *		Automatically (re)allocates enough space for
 *		line.  These routines are system dependant, and
 *		will probably need to be fixed when porting.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */


#include <sys/ioctl.h>

#include <s-string.h>



/*
 *  Read a string from a terminal into a String with some fancy
 *  options and some editing, including delete character, delete
 *  word and kill line.  Automatically allocates all necessary
 *  storage.
 *  Parameters:
 *  -  INFILE:	the file to read the string from.
 *  -  ECHOFILE: the file to which echoing is done.
 *  -  LINE:	pointer to the String where the result should be placed.
 *		This String must be initialized to something useful,
 *		i e NULL or a malloc():ed area.
 *  -  MAXLEN: maximum number of characters to allow in input.
 *		Excess characters are ignored.  -1 means no limit.
 *  -  QUIT_CHARS: a NUL-terminated string of characters that can
 *		be used to end the input.  Typically contains the
 *		newline character ('\n').  The character used to
 *		exit, will be part of the resulting string.
 *  -  INSERT_CHARS: a NUL-terminated string of characters that
 *		can build up the resulting String.  NULL means
 *		normal printable characters including tab.  ""
 *		means all characters without special meaning.
 *  -  ECHO_CHAR: the caracter that is to be echoed. NUL means no
 *		echoing is done, and EOF means echo the read
 *		characters.
 *  Returns values:
 *	    0	Something went wrong - probably out of memory
 *	  EOF	End of file reached (includes Ctrl-D)
 *	Other	The character that caused the exit
 *
 *  Even if input_line() returns FAILURE, the value of *LINE is
 *  valid, and can be free():ed or realloc():ed, though the contents
 *  is probably just gibberish.
 */
extern  int
input_line (FILE		* infile,
	    FILE		* echofile,
	    String		* line,
	    String_size		  maxlen,
	    char		* quit_chars,
	    char		* insert_chars,
	    int			  echo_char);



/*
 *  Read a line from standard input, ended by newline or EOF.
 *  The terminating newline is removed from the result.
 */
extern  int
read_line (String	* line);



/*
 *  Read a password from standard input (no echo), terminated by
 *  newline or EOF.  The terminating newline is removd from the
 *  result.
 */
extern  int
read_password (String	* line);

