// -*- C++ -*-
/**
 * \file GPreamble.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GPREAMBLE_H
#define GPREAMBLE_H

#include "ControlPreamble.h"
#include "GnomeBase.h"

namespace Gtk {
class Button;
class TextView;
}

/**
 * This class implements the dialog to modify the LaTeX preamble
 */
class GPreamble : public GnomeCB<ControlPreamble> {
public:
	///
	GPreamble(ControlPreamble & c);
	///
	~GPreamble();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	///
	void connect_signals();
	///
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// generated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::TextView * preamble() const;

	///
	SigC::Connection slot_preamble_;


};

#endif
