-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          15.11.96 H.-F. Vogt  (vogt@ilaws6.luftfahrt.uni-stuttgart.de)
--
-------------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
--
--  IsLittleEnd
--
--  test if system is little endian, if yes, print IS_LITTLE, else print nothing
--
-- ----------------------------------------------------------------------------

with System, Ada.Text_Io;
use  System;
procedure IsLittleEnd is

begin
   if Default_Bit_Order = Low_Order_First then
      Ada.Text_Io.Put ("IS_LITTLE");
   end if;
end IsLittleEnd;
