// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.IO;
using System.Collections.Generic;

namespace Anculus.Core
{
	public interface IConfigurationSection
	{
		string Name { get; }

		IConfigurationSection this[string name] { get; }

		bool IsRoot { get; }
		IConfigurationSection Parent { get; }

		bool IsReadOnly { get; }

		bool ContainsSection (string name);
		IEnumerable<string> SectionNames { get; }
		IEnumerable<IConfigurationSection> Sections { get; }
		void RemoveSection (string name);

		IEnumerable<string> Keys { get; }
		bool ContainsKey (string name);
		void Remove (string name);

		T Get<T> (string name) where T : new ();
		object GetObject (string name);
		ConfigurationObjectType GetObjectType (string name);

		byte GetByte (string name);
		sbyte GetSByte (string name);
		bool GetBool (string name);
		short GetShort (string name);
		int GetInt (string name);
		long GetLong (string name);
		ushort GetUShort (string name);
		uint GetUInt (string name);
		ulong GetULong (string name);
		float GetFloat (string name);
		double GetDouble (string name);
		string GetString (string name);
		char GetChar (string name);
		decimal GetDecimal (string name);
		DateTime GetDateTime (string name);
		
		T[] GetArray<T> (string name);
		IList<T> GetList<T> (string name);

		byte GetByte (string name, byte defaultValue);
		sbyte GetSByte (string name, sbyte defaultValue);
		bool GetBool (string name, bool defaultValue);
		short GetShort (string name, short defaultValue);
		int GetInt (string name, int defaultValue);
		long GetLong (string name, long defaultValue);
		ushort GetUShort (string name, ushort defaultValue);
		uint GetUInt (string name, uint defaultValue);
		ulong GetULong (string name, ulong defaultValue);
		float GetFloat (string name, float defaultValue);
		double GetDouble (string name, double defaultValue);
		string GetString (string name, string defaultValue);
		char GetChar (string name, char defaultValue);
		decimal GetDecimal (string name, decimal defaultValue);
		DateTime GetDateTime (string name, DateTime defaultValue);

		T[] GetArray<T> (string name, T[] defaultValue);
		IList<T> GetList<T> (string name, IList<T> defaultValue);

		void Set<T> (string name, T value);
		void SetObject (string name, object value);
		void SetByte (string name, byte value);
		void SetSByte (string name, sbyte value);
		void SetBool (string name, bool value);
		void SetShort (string name, short value);
		void SetInt (string name, int value);
		void SetLong (string name, long value);
		void SetUShort (string name, ushort value);
		void SetUInt (string name, uint value);
		void SetULong (string name, ulong value);
		void SetFloat (string name, float value);
		void SetDouble (string name, double value);
		void SetString (string name, string value);
		void SetChar (string name, char value);
		void SetDecimal (string name, decimal value);
		void SetDateTime (string name, DateTime value);

		void SetArray<T> (string name, T[] value);
		void SetList<T> (string name, IList<T> value);
	}
}