// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;

namespace Anculus.Core
{
	public delegate void LogEventHandler (object sender, LogEventArgs args);

	public class LogEventArgs : EventArgs
	{
		private LogLevel _level;
		private string _logger;
		private object _message;
		private Exception _exception;

		public LogEventArgs (LogLevel level, string logger, object message, Exception exception)
		{
			this._level = level;
			this._logger = logger;
			this._message = message;
			this._exception = exception;
		}

		public LogLevel LogLevel
		{
			get { return _level; }
		}

		public string Logger
		{
			get { return _logger; }
		}

		public object Message
		{
			get { return _message; }
		}

		public Exception Exception
		{
			get { return _exception; }
		}
	}
}