// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Globalization;
using System.Collections.Generic;

namespace Anculus.Core
{
	public abstract class AbstractTranslationBackend : ITranslationBackend
	{
		protected static CultureInfo _culture = CultureInfo.CurrentCulture;
		
		public virtual string GetString (string key)
		{
			return LookupSingular (key);
		}

		public virtual string GetString (string key, params object[] args)
		{
			return String.Format (_culture, LookupSingular (key), args);
		}

		//this mimics the plural behavior as described in http://www.gnu.org/software/gettext/manual/gettext.html#Plural-forms
		public virtual string GetPluralString (string key, string plural, int n)
		{
			//FIXME: the 'n' parameter must also be formatted
			if (n == 1)
				return LookupSingular (key);
			else
				return LookupPlural (key, plural, n);
		}

		public virtual string GetPluralString (string key, string plural, int n, params object[] args)
		{
			//FIXME: the 'n' parameter must also be formatted
			if (n == 1)
				return String.Format (_culture, LookupSingular (key), args);
			else
				return String.Format (_culture, LookupPlural (key, plural, n), args);
		}
		
		protected abstract string LookupSingular (string key);
		protected abstract string LookupPlural (string key, string plural, int n);
	}
}
