/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cmds.y,v 1.45 2002/02/03 11:09:26 dolecek Exp $ */

%{

/*
 * gramatics for CSacek
 */

#include <stdio.h>
#include "csacek.h"

#include "csa_cmds.h"

#ifdef CSA_DEBUG
/* if DEBUGging, print more verbose error message */
#  define YYERROR_VERBOSE 1
#endif

/* parameter to yyparse */
#define YYPARSE_PARAM p

/* use Apache ap_palloc() instead of malloc(3) and undef free() */
#define malloc(c)	ap_palloc(((csa_params_t *)p)->pool_tmp, (c))
#define free(c)	

#ifndef HAVE_ALLOCA
/* some systems do not have alloca(); use ap_palloc() and tmp pool in */
/* that case */
#define alloca		malloc
#endif /* !HAVE_ALLOCA */

/* redefine to add csa_params_t pointer to csa_yylex() call */
#undef yylex
#define yylex(x)	csa_yylex((csa_params_t *)p, (x))

/* one argument in queue of args */
struct csa_arg {
	const char	*key;			/* name of item */
        const char	*value;                 /* value of the item */
        int     param_type;             /* type mask */
	int	opaque;			/* opaque data */
        struct csa_arg       *prev, *next;
};

struct csa_arglist {
        csa_arg_t *start;
        csa_arg_t *end;
};

/* local functions */
static void csa_yyerror __P((const char *));
static const char *x_arg_take_last __P((csa_params_t *, int, int *));
static void x_arg_insert __P((csa_params_t *, const char *, int, int));

/* gramatics */
#if defined(__ANSI_C__) && !defined(__STDC__)
# define __STDC__
#endif
%}


%pure_parser
%union {
	struct csa_yyres res;
}
%token <res> CSA_STRING CSA_EQUATION
%token	CSA_CMD0	CSA_CMDX	CSA_MYCHARSET
%type	<res> string

%start commands

%%
commands	
	: commands ';' cmd
	| cmd 
	;

cmd
        : CSA_CMD0
		{
			if (csa_cmd_execute(p) != 0)
				YYFAIL;
		}
        | CSA_CMDX misc_list
		{
			if (csa_cmd_execute(p) != 0)
				YYFAIL;
		}
	| CSA_MYCHARSET '=' string
		{
			if (csa_cmd_execute(p) != 0)
				YYFAIL;
		}
        ;

misc_list
	: /* nothing */
	| misc_list equation
        | misc_list string
	;

equation
	: string '=' string
        	{
			x_arg_insert((csa_params_t *) p, "",
				CSA_EQUATION, 0);
			/* to distinguish it were not two strings but one */
			/* equation */
                }
        ;

string
	: CSA_STRING
		{
			x_arg_insert((csa_params_t *) p, $1.s, CSA_STRING,
				$1.opaque);
                }
        ;

%%

/* remainder of hand-crafted code */

/*
 * called when error occurs during yyparse()
 */
/* ARGSUSED */ /* avoid lint warning when DEBUG is not defined */
static void
csa_yyerror(s)
  const char *s;
{
#if 0
	/* OOL, we can't pass the debug log FILE * */
        csa_debug(p->dbg, "csa_yyerror: %s", s);
#endif
}

/* 
 * inserts value provided into argument queue (the arguments are later used by
 * by functions implementing CSacek commands)
 * returns 0 if succesful
 */
static void 
x_arg_insert(p, value, type, opaque)
  csa_params_t *p;
  const char *value;
  int type, opaque;
{
	csa_arg_t	*newi;
	csa_arglist_t	*list=csa_yy_getarglist(p->yy);
	int vopaque;
	
	newi = (csa_arg_t *)ap_pcalloc(p->pool_tmp, sizeof(csa_arg_t));

	if (type == CSA_STRING) {
		newi->key = NULL;
		newi->value = ap_pstrdup(p->pool_tmp, value);
		newi->param_type = CSA_P_STRING;
		newi->opaque = opaque;
	}
	else if (type == CSA_EQUATION) {
		newi->value = x_arg_take_last(p, CSA_P_STRING, &vopaque);
		newi->key  = x_arg_take_last(p, CSA_P_STRING, NULL);
		newi->param_type = CSA_P_EQUATION;
		newi->opaque = vopaque;
	}
	else 
		return;
		
	/* insert item into two-way chained queue */
	newi->prev 	 = list->end;
	if (list->end) list->end->next = newi;
	list->end = newi;

	/* set pointer to a beginning of queue, if it's not set already */
	if (!list->start) list->start = list->end;

	return;
}

/*
 * returns first item from argument queue, whose type is compatible
 * with type mask supplied
 * returns item found or NULL in case of error or empty list
 */
const csa_arg_t *
csa_arg_take(p)
  csa_params_t *p;
{
	csa_arglist_t *list=csa_yy_getarglist(p->yy);
	csa_arg_t *retval=NULL;
  	int type_mask = csa_yy_getcmdparammask(p->yy);;

	if (list->start != NULL && (type_mask & list->start->param_type) )
	{
		retval = list->start;

		if (list->start->next) {
			list->start->next->prev = NULL;
			list->start = list->start->next;
		}
		else
			/* empty list */
			list->start = list->end = NULL;

		retval->prev = retval->next = NULL;
	}

	return retval;
}

/*
 * Returns first item on argument list, the item is not taken from
 * list.  Can be used to check the value without actually processing it.
 */
const csa_arg_t *
csa_arg_peek(p)
  csa_params_t *p;
{
	return csa_yy_getarglist(p->yy)->start;
}

/* 
 * the same as previous csa_arg_take(), besides fact it returns
 * LAST item
 * returns item found or NULL in case of error or empty list
 */
static const char *
x_arg_take_last(p, type_mask, opaquep)
  csa_params_t *p;
  int type_mask, *opaquep;
{
	csa_arglist_t *list=csa_yy_getarglist(p->yy);
	csa_arg_t *retval=NULL;

	if (list->end && (type_mask & list->end->param_type) )
	{
		retval = list->end;

		if (list->end->prev) {
			list->end->prev->next = NULL;
			list->end = list->end->prev;
		}
		else
			/* empty list */
			list->end = list->start = NULL;

		retval->prev = retval->next = NULL;
	}

	if (opaquep && retval)
		*opaquep = retval->opaque;

	return (retval) ? retval->value : NULL;
}

/*
 * returns member ``key'' from csa_arg_t structure
 */
const char *
csa_arg_getkey(item)
  const csa_arg_t *item;
{
	return item->key;
}

/*
 * returns ``value'' from csa_arg_t structure
 */
const char *
csa_arg_getvalue(item)
  const csa_arg_t *item;
{
	return item->value;
}

/*
 * returns flags from csa_arg_t structure
 */
int
csa_arg_getflags(item)
  const csa_arg_t *item;
{
	return item->opaque;
}

/*
 * creates new csa_arglist_t structure and returns it
 */
csa_arglist_t *
csa_arg_newlist(wpool)
  struct pool *wpool;
{
	return (csa_arglist_t *) ap_pcalloc(wpool, sizeof(csa_arglist_t));
}

/*
 * Clears the passed csa_arglist_t structure.
 */
void
csa_arg_clrlist(al)
  csa_arglist_t *al;
{
	al->start = al->end = NULL;
}
