/*
 *  config.h
 *  mod_musicindex
 *
 *  $Id: config.h,v 1.19 2004/05/27 12:25:14 boudinr Exp $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2004 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1, or (at your option)
 *  any later version.
 *
 */
 
#ifndef CONFIG_H
#define CONFIG_H

#include "mod_musicindex.h"
#include <strings.h>

void *create_musicindex_config(apr_pool_t *p, char *dummy);

void *merge_musicindex_configs(apr_pool_t *p, void *basev, void *addv);

void sort_or_fields(cmd_parms *cmd, char *list, const char *optstr);

const char *sort_order(cmd_parms *cmd, void *d, const char *optstr);
const char *set_fields(cmd_parms *cmd, void *d, const char *optstr);
const char *music_lister(cmd_parms *cmd, void *d, int bool);
const char *allow_stream(cmd_parms *cmd, void *d, int bool);
const char *allow_download(cmd_parms *cmd, void *d, int bool);
const char *allow_search(cmd_parms *cmd, void *d, int bool);
const char *set_cache_path(cmd_parms *cmd, void *d, const char *optstr);
const char *set_page_title(cmd_parms *cmd, void *d, const char *optstr);
const char *set_ice_server(cmd_parms *cmd, void *d, const char *optstr);
const char *set_css_default(cmd_parms *cmd, void *d, const char *optstr);
const char *set_cookie_life(cmd_parms *cmd, void *d, const char *optstr);

#endif	/* CONFIG_H */
