/*
 *  mod_musicindex.h
 *  mod_musicindex
 *
 *  $Id: mod_musicindex.h 651 2006-07-06 00:45:53Z varenet $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2006 Regis BOUDIN
 *  Copyright (c) 2003-2005 Thibaut VARENE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 2.1,
 *  as published by the Free Software Foundation.
 *
 */

#ifndef MOD_MUSICINDEX_H
#define MOD_MUSICINDEX_H

#include <httpd.h>
#include <http_config.h>
#include <http_request.h>
#include <http_protocol.h>
#include <http_log.h>

/* Define to the address where bug reports for this package should be sent. */
#undef PACKAGE_BUGREPORT

/* Define to the full name of this package. */
#undef PACKAGE_NAME

/* Define to the full name and version of this package. */
#undef PACKAGE_STRING

/* Define to the one symbol short name of this package. */
#undef PACKAGE_TARNAME

/* Define to the version of this package. */
#undef PACKAGE_VERSION

#include "mod_musicindex_config.h"

/*
 * Current version number & authors
 */
#define MUSIC_VERSION_STRING	PACKAGE_VERSION		/**< Version string */
#define MUSIC_AUTHORS_STRING	"R. Boudin & T. Varene"	/**< Authors */

/*
 * Compile time configuration option
 */
#undef NO_TITLE_STRIP	/* Disable pretty printing for untagged files */
#undef NO_BR_NOMINAL	/* Disable display of nominal bitrate when available */
#undef SHOW_THUMBNAILS	/* Disable custom folder icon in folder listings */
#define NEW_HEADER	/* Enable new header display */


/* these are not defined on BSD */
#ifndef FALSE
 #define FALSE 0
 #define TRUE !FALSE
#endif

/* a very common macro */
#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))

/*
 * Various constants used almost everywhere
 */
#define SB_ALBUM	'A'		/**< Sort by album */
#define SB_ARTIST	'B'		/**< Sort by artist */
#define SB_DATE		'D'		/**< Sort by date */
#define SB_GENRE	'G'		/**< Sort by genre */
#define SB_FREQ		'E'		/**< Sort by frequency (samplerate) */
#define SB_FILETYPE	'F'		/**< Sort by filetype */
#define SB_LENGTH	'L'		/**< Sort by length */
#define SB_FILENAME	'M'		/**< Sort by filename */
#define SB_TRACK	'N'		/**< Sort by track */
#define SB_POSN		'P'		/**< Sort by Part Of Set nb */
#define SB_MTIME	'Q'		/**< Sort by modification time */
#define SB_BITRATE	'R'		/**< Sort by bitrate */
#define SB_SIZE		'S'		/**< Sort by filesize */
#define SB_TITLE	'T'		/**< Sort by title */
#define SB_URI		'U'		/**< Sort by URI */
#define SB_DIR		'V'		/**< Sort by directory */
#define SB_DEFAULT	'U'		/**< Default sort order (used in search results) */
#define SB_RANDOM	'Z'		/**< Sort randomly */

#define ARG_NUMBER	18		/**< Number of args to sort lists */


/*
 * Flags used in mu_config struct, fields "options" and "options_not".
 * 16 bits max.
 */
 
/* First, the flags set by the configuration */
#define MI_ACTIVE	(1 << 0)	/**< Music indexing is enabled */

#define MI_ALLOWSTREAM	(1 << 1)	/**< Stream is permitted */
#define MI_ALLOWDWNLD	(1 << 2)	/**< Download is permitted */
#define MI_ALLOWSEARCH	(1 << 3)	/**< Search is permitted */
#define MI_ALLOWTARBALL	(1 << 4)	/**< Tarball generation is permitted */

/** One of stream, download or tarball is allowed */
#define	MI_ALLOWFETCH	(MI_ALLOWSTREAM | MI_ALLOWDWNLD | MI_ALLOWTARBALL)

/* XXX TODO : move these flags to a different parameter in the structure */
/* The flags set on requests */
#define MI_STREAM	(1 << 5)	/**< Stream request */
#define MI_ALL		(1 << 6)	/**< Request for all files */
#define MI_RECURSIVE	(1 << 7)	/**< Recursive action */
#define MI_RSS		(1 << 8)	/**< RSS feed */
#define MI_PODCAST	(1 << 9)	/**< Podcast */
#define MI_RANDOMDIR	(1 << 10)	/**< Random directory redirection. */
#define MI_TARBALL	(1 << 11)	/**< Tarball creation. */

#define MI_STREAMLST	(MI_STREAM)
#define MI_STREAMALL	(MI_STREAM | MI_ALL)
#define MI_STREAMCOOKIE	(MI_STREAM | MI_COOKIEOP)
#define MI_STREAMRQ	(MI_STREAMLST | MI_STREAMALL | MI_STREAMCOOKIE)

#define MI_DWNLDLST	(MI_TARBALL)
#define MI_DWNLDALL	(MI_TARBALL | MI_ALL)
#define MI_DWNLDCOOKIE	(MI_TARBALL | MI_COOKIEOP)
#define MI_DWNLDRQ	(MI_DWNLDLST | MI_DWNLDALL | MI_DWNLDCOOKIE)

/* The cookie-related flags */
#define MI_COOKIEOP	(1 << 12)	/**< Any cookie operation */
#define MI_COOKIEADD	(1 << 13)	/**< Add a file to the playlist */
#define MI_COOKIEDEL	(1 << 14)	/**< Remove a file from the playlist */

#define MI_COOKIEADDLST (MI_COOKIEOP | MI_COOKIEADD)
#define MI_COOKIEDELLST (MI_COOKIEOP | MI_COOKIEDEL)
#define MI_COOKIEADDALL	(MI_COOKIEOP | MI_COOKIEADD | MI_ALL)
#define MI_COOKIEPURGE	(MI_COOKIEOP | MI_COOKIEDEL | MI_ALL)
#define MI_COOKIESTREAM	(MI_COOKIEOP | MI_STREAM)
#define MI_COOKIEDWNLD	(MI_COOKIEOP | MI_TARBALL)

#define MI_ALLOPS	(MI_COOKIEOP | \
			MI_COOKIEADD | \
			MI_COOKIEDEL | \
			MI_STREAM    | \
			MI_TARBALL   | \
			MI_ALL)

/* Flags for internal use */
#define MI_QUICKPL	(1 << 15)	/**< "Quick Play" (disable bitrate/length) */

/* Extended options set: Flags not stored in config options but used directly.
   These can exceed the 16bit boundary, with care. */
#define	MI_CUSTOM	(1 << 16)	/**< Used to deal with custom playlist in make_music_entry */
#define MI_ALLOWRSS	(1 << 17)	/**< Used within make_music_entry to flag permitted RSS on directories */

/*** End of mu_config flags ***/


/*
 * Flags used in mu_ent struct, field "flags".
 * 8 bits max.
 */

/* Following can be cached */
#define EF_VBR		(1 << 0)	/**< File is VBR */
/* Following can *NOT* be cached and must be updated everytime */
#define EF_INCACHE	(1 << 1)	/**< File is already in cache */
#define EF_ALLOWSTREAM	(1 << 2)	/**< Stream is permitted */
#define EF_ALLOWDWNLD	(1 << 3)	/**< Download is permitted */
#define EF_ALLOWTARBALL	(1 << 4)	/**< Tarball is permitted (used for directories) */
#define EF_ALLOWRSS	(1 << 5)	/**< gross workaround for directories */

/** defines which flags will actually be saved in cache */
#define EF_FLAGSTOSAVE	(EF_VBR)

/*** End of mu_ent flags ***/

#define MAX_STRING	1024		/**< Common reference for maximum string size. */

#define MI_LOG_PREFIX	"[musicindex] "	/**< String used to prefix log messages */

#ifndef BUILD_FOR_APACHE2

 /* some things have to be redefined for apache 1.3 to use the same declaration
    in both apache 1&2 versions of the program */
 #define apr_pool_t	pool		/**< type name is different in apache 1.3 and 2 */

 #define AP_INIT_NO_ARGS(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, NO_ARGS, help }
 #define AP_INIT_RAW_ARGS(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, RAW_ARGS, help }
 #define AP_INIT_TAKE1(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, TAKE1, help }
 #define AP_INIT_FLAG(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, FLAG, help }

 #define ap_is_directory(pool, name) ap_is_directory(name)	/**< function changed in apache2 */
 #define ap_set_content_type(r, string) (r->content_type = string)
 #define apr_pool_create(child, parent) ((*(child)) = ap_make_sub_pool(parent))
 #define ap_sub_req_lookup_uri(p, r, ptr) ap_sub_req_lookup_uri(p, r)
 #define REQUEST_USER(rec) (rec->connection->user)

#else

 #include <apr_strings.h>
 #include <apr_base64.h>
 #include <ap_compat.h>

 #ifdef APLOG_ERR
  #undef APLOG_ERR
  #define APLOG_ERR LOG_ERR, 0		/**< dirty trick because ap_log_rerror takes one more arg in apache2 */
 #endif

 #define REQUEST_USER(rec) (rec->user)

#endif	/* ! __BUILD_FOR_APACHE2 */

/**
 * first struct to handle yet unparsed files.
 * DEV NOTE: filename is the path to the file on the filesystem,
 * while uri is the path to the file on the webserver.
 */
typedef struct mu_ent_names {
	char filename[MAX_STRING];	/**< file path */
	char uri[MAX_STRING];		/**< file URI */
} mu_ent_names;

/** 
 * Music entry. Contains various data about an associated file.
 * Special care has been taken toward typing to avoid memory waste.
 */
typedef struct mu_ent {
	signed char filetype;	/**< file type, associated to a display string and a mimetype string */
	unsigned char flags;	/**< flags associated with the file */
	unsigned char track;	/**< track number */
	unsigned char posn;	/**< "part of a set" number, that is, disc number */
	unsigned short date;	/**< date (year actually) */
	unsigned short freq;	/**< samplerate frequency */
	unsigned short length;	/**< length in seconds */
	unsigned long bitrate;	/**< bitrate in bits per second */
	unsigned long size;	/**< size in bytes */
	unsigned long mtime;	/**< last modification time */
	const char *file;	/**< file path */
	const char *filename;	/**< file path */
	const char *uri;	/**< file URI (unique) */
	const char *album;	/**< album (if any) */
	const char *artist;	/**< artist (if any) */
	const char *title;	/**< title (as shown on the webpages) */
	const char *genre;	/**< genre (type of music - if any) */
	struct mu_ent *next;
} mu_ent;

typedef struct mu_config mu_config;

typedef struct {
	void* (*opendir)(request_rec *r, mu_ent **entries, const mu_config *const conf, const mu_ent_names * const names, unsigned long soptions);
	const char* (*readdir)(void *dir, const mu_config *const conf);
	void (*closedir)(void *dir, const mu_config *const conf);
	mu_ent* (*make_entry)(request_rec *r, apr_pool_t *pool, FILE *const in, mu_ent *const head, const mu_config *const conf, mu_ent_names *const names);
	void (*write)(request_rec *r, mu_ent *entry, const mu_config *const conf, const mu_ent_names * const names);
} cache_backend;

/** sort function pointer type (see inf.c) */
typedef short (*inf_ptr)(const mu_ent *const, const mu_ent *const);

/** Configuration handling structure. We use it to share configuration
 * throughout the whole module */
struct mu_config {
	unsigned short cookie_life;	/**< cookie lifetime in seconds */
	short rss_items;		/**< number of entries in the RSS file */

	unsigned short options;		/**< diverse options */
	unsigned short options_not;	/**< used to disable options */

	char order[ARG_NUMBER];		/**< Sort order */
	char fields[ARG_NUMBER];	/**< Fields to display */
	inf_ptr order_functions[ARG_NUMBER];	/**< Functions array for sort */

	const char *title;		/**< title of the page */

	const char *directory;		/**< directory where musicindex files are stored */

	const char *css;		/**< path to the css */

	char *search;			/**< string to search */

	const char *iceserver;		/**< adress of an icecast server */

	const char *custom_list;

	const cache_backend *cache;
	void *cache_setup;

	unsigned short dir_per_line;	/**< number of directories to display per line */
};


/* i18n stuff */
#ifdef HAVE_GETTEXT
 #include <libintl.h>
 #define _(String)	gettext(String)
#else
 #define _(String)	String
#endif	/* HAVE_GETTEXT */


extern module MODULE_VAR_EXPORT musicindex_module;

#endif	/* MOD_MUSICINDEX_H */
