#!/usr/bin/perl -w
#
#  Test that DropParam works as expected
#
# $Id: drop-param.t,v 1.3 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

    my $conf = <<EOF;
DropAction status=403
DropParam foo
DropParam bar
EOF

writeConf( $conf );
restart();


#
#  Get a random path, so we can be sure we'll get a 404 code.
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );


#
#  Now we make some requests.
#
is( makeGETRequest( "/$path/foo.cgi" ),
    404, "/$path/foo.cgi allowed as expected" );

is( makeGETRequest( "/foo.cgi?foo=x" ),
    403, "foo paramater dropped as expected: GET" );
is( makeHEADRequest( "/foo.cgi?foo=x" ),
    403, "foo paramater dropped as expected: HEAD" );
is( makePOSTRequest( "/?foo=x" ),
    403, "foo paramater dropped as expected: POST" );



is( makeGETRequest( "/foo.cgi?bar=x" ),
    403, "bar paramater dropped as expected: GET" );
is( makeHEADRequest( "/foo.cgi?bar=x" ),
    403, "bar paramater dropped as expected: HEAD" );
is( makePOSTRequest( "/?bar=x" ),
    403, "bar paramater dropped as expected: POST" );


#
#  Cleanup
#
cleanConf();
restart();
