<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title></title>
    <filename>index</filename>
  </compound>
  <compound kind="file">
    <name>apreq.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq_8h</filename>
    <class kind="struct">apreq_value_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>556c7afa0862221393d99ad2009d5573</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_NONSTD</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>d0d41b6ef95a91ffeba604a9c362d4a0</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_DATA</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>bbc00f59a8eba6ac0fb5c47035e9e600</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_BLOCK_SIZE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>f64b0d4a0a39eec6249b0990b6328457</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>73c29189f741fb83ade5b4b7f4e8c2d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_BRIGADE_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>93e0b72fb65f5856ed2067e39d00f3b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_NELTS</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>8dbf808c309804b72c2ca14efce76cf0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_OFF</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>c0a32ded2f13208529721ebe7354d635</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_ON</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>39c379f0b425aa9c1ebaa849a0af4299</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_GET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>184d7699d412702ae8cecf1a31574922</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_SET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>65dcca5633e0d67a13c9db43739ab7fb</anchor>
      <arglist>(f, name, value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aa4a424f223081f61133a63ba5342eb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>de1fec789af2f7724454814c8e1ed9da</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>d85dc71cbb7c617208b48544424d0ac4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a39f8309b89462b7717a6ca26c27ee61</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>c476d0bb89a7309a2d0acb558391e14d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ca5e56b76b16c2c64ee6ee84ddeb7651</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>27126294cdd0a1d7e60436c1bd3d3f3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>190e740a4aa128d7550938274437d5a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_attr_to_type</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>c01926d3b46471c3de5b30b8873a5335</anchor>
      <arglist>(T, A, P)</arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_charset_t</name>
      <anchor>634446af852308ac3d8d1757bc739115</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_join_t</name>
      <anchor>a26db627cceece7744dacb2cf29a6328</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_AS_IS</name>
      <anchor>a26db627cceece7744dacb2cf29a6328ad87f2edbcdbd91e42ba13d8a0340b76</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_ENCODE</name>
      <anchor>a26db627cceece7744dacb2cf29a6328cac98124ea65c0ef666e10498ee2da42</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_DECODE</name>
      <anchor>a26db627cceece7744dacb2cf29a6328ca0b3147e55a2aa1ec104573c8f8fcad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_QUOTE</name>
      <anchor>a26db627cceece7744dacb2cf29a6328282c99e7cf9bb891b62fb6e7961a327f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_match_t</name>
      <anchor>e40c148b9e3268e34981d69082b3be33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_FULL</name>
      <anchor>e40c148b9e3268e34981d69082b3be33a6c2b3b3bebde576cc0615a1d4ab9418</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_PARTIAL</name>
      <anchor>e40c148b9e3268e34981d69082b3be333a83d390e2c5f4504928eb5ad0b01ad7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_expires_t</name>
      <anchor>dce8f675f28f392553584593aa02c30c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_HTTP</name>
      <anchor>dce8f675f28f392553584593aa02c30c57dcdfaab676713137cea23a768a1cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_NSCOOKIE</name>
      <anchor>dce8f675f28f392553584593aa02c30cc8055cf937924e3ea79c6bf73d00e89f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_value_table_add</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a7195b9d484911cc58cd317ffba93e40</anchor>
      <arglist>(const apreq_value_t *v, apr_table_t *t)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>5d20f05c4b90a1a5dd7cb1794c03386d</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_pre_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>d373757bd9469ac56e573a9cfa21d401</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_post_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>2c8690086565e77aa984e17ba66b1c66</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_cookie.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__cookie_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_cookie_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_MAX_LENGTH</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>37ee4f59075a74fb4c68b0c59ef20842</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_value_to_cookie</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>04cdf6697a1510076e89c47c2030c24c</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_version</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>d85bbee41ab977df4a6e45d0608983f3</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_version_set</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>95f1d170c0ebbc49e7bc4ffdf7a4f1b0</anchor>
      <arglist>(apreq_cookie_t *c, unsigned v)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_secure</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>d28f3bcab852d424b3936d71183ef7ec</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a5ea88e5f17cbfbd9322a56843025ea9</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>9eac3b9fed9d8c5b9abee904c33a96b0</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_tainted</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>619cd2f7fa1dead24c5d02366648a333</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a2aa72c21e4bf7307fc693ff7ecf7162</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>697c127c1a7f6d3001f644053362187f</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_cookie_header</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>c0e4279cae55dcd483ae5649f8491452</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *jar, const char *header)</arglist>
    </member>
    <member kind="function">
      <type>apreq_cookie_t *</type>
      <name>apreq_cookie_make</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>02d73f8a48941f866053a254efd0c3af</anchor>
      <arglist>(apr_pool_t *pool, const char *name, const apr_size_t nlen, const char *value, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_cookie_as_string</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>b10a05c8a6226ada5e346414e30f86bd</anchor>
      <arglist>(const apreq_cookie_t *c, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>apreq_cookie_serialize</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>6db4ed82a14e82320690ca335a8c89cb</anchor>
      <arglist>(const apreq_cookie_t *c, char *buf, apr_size_t len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_cookie_expires</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>91126833a93e841dc72b055f0a0c3219</anchor>
      <arglist>(apreq_cookie_t *c, const char *time_str)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_error.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__error_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APR_EBADARG</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>26a46be088839260021da989edcc4401</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_GENERAL</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7eae3941550bcd7684efdb1f97ddd357</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_TAINTED</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>446a863044e41dd8022e6311bb14dbd8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_INTERRUPT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>8f7f22c139d405197fb40fc24ea88f3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADDATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>e0a44cf61358434d9e06361821842f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADCHAR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>6b3acd6dfc132e3ea8ac310bf63aba04</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADSEQ</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>1ca7fd544bfb795c632bb105cfc2c0fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>d753690860f0cda7ed53cf707e7173b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>dcaf83f9fe493c5bef7775083edf6e12</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADUTF8</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>93c627da9da8f5922948177c5cf4125b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NODATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7cd745b9908f43dd0a5af888c2057500</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTOKEN</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>b24e52d772fd927300dcf69f3573fe3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>2147d545b92cf6c96809f6b4869c813c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7589b34342e065d712ebfc83f3928d7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOPARSER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7fdcf2c03dadda05c48c8bb1928d0731</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_MISMATCH</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7e9ec99ca441cb841e6b88a12b4c5141</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_OVERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>47e84cf0c2ae84140f05aec286b63548</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_UNDERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>eced3896a48094286ff3a8337f362337</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTEMPTY</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>0998dda171eae58afacce44612a6c844</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_strerror</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>7717ebfd951f7f44dd85c233905bd06d</anchor>
      <arglist>(apr_status_t s, char *buf, apr_size_t bufsize)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_module.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__module_8h</filename>
    <includes id="apreq__cookie_8h" name="apreq_cookie.h" local="yes" imported="no">apreq_cookie.h</includes>
    <includes id="apreq__parser_8h" name="apreq_parser.h" local="yes" imported="no">apreq_parser.h</includes>
    <includes id="apreq__error_8h" name="apreq_error.h" local="yes" imported="no">apreq_error.h</includes>
    <class kind="struct">apreq_handle_t</class>
    <class kind="struct">apreq_module_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MODULE</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>96830d465412c2c8f641ac742382ecec</anchor>
      <arglist>(pre, mmn)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_cookie</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>78e05beddc5d335d3c2bc30eb30a4986</anchor>
      <arglist>(req, name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_module_status_is_error</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>56fbaf1314946cc098e1dfd98e9e9cb7</anchor>
      <arglist>(apr_status_t s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_jar</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>7140953f033551df94c276c4254d31b8</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_args</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>f944a86b25bd66da0bb185d73a6044b4</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_body</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>712989686a218cdf196a56a9966f5546</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_jar_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>f20c031c5c37ca1644a613ccc8d9527c</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_args_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>d39911b6ba5364008c96394e17871c18</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_body_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>9b623b1d070c18683b6bbc7fe34402aa</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>28b4c0bdb7af6e234f4808db1ebbca62</anchor>
      <arglist>(apreq_handle_t *req, const apreq_parser_t **parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>f52492547133e02d793258fbc9859f77</anchor>
      <arglist>(apreq_handle_t *req, apreq_parser_t *parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_add</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>828931dcc30bb57c44faeb3579c6b53e</anchor>
      <arglist>(apreq_handle_t *req, apreq_hook_t *hook)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a12aea1e35e109882ce050579e934cf5</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>29294cc182b76b7b67dc7cb8483635ba</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>c19e1f787660cbf52a6e3ca3da3b5a9c</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>6108801436d99af776a009f1f7d02229</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>8d1f1ac49c06f7f44266ced26d98b183</anchor>
      <arglist>(apreq_handle_t *req, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>1ef14a149803c4474a789294aac6f28c</anchor>
      <arglist>(apreq_handle_t *req, const char **path)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_cgi</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>d47430f4c60771eacf8b6a968a9bfc67</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_custom</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>3fa6753f412604b78847a8b398badc18</anchor>
      <arglist>(apr_pool_t *pool, const char *query_string, const char *cookie, apreq_parser_t *parser, apr_uint64_t read_limit, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>c69e5296f6f326debc53d1f69cbca499</anchor>
      <arglist>(apreq_handle_t *req, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_params</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>43428b806ff04191103b82958a080dd5</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_cookies</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a1d548c6cc5f8e344d6d2b0a2ab990ec</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_param.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__param_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_param_t</class>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_param_is_tainted</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>bac6dac9f29c659ac43b2588d1a01c68</anchor>
      <arglist>(const apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_on</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>63412e3d56bcc82b65672141dbb81a43</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_off</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>c4caea9761e7c4b698dd11fd5a28dc74</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_set</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>63c378f4acf06965c68b9eef80e9784d</anchor>
      <arglist>(apreq_param_t *p, apreq_charset_t c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_get</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>7b732394e86bc5a8b47d59978e6fef99</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_value_to_param</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>ac3261db400da628886fcba39936a063</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param_make</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>4b65c4fbcc5bdffd8d00b467d68a12f9</anchor>
      <arglist>(apr_pool_t *p, const char *name, const apr_size_t nlen, const char *val, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_param_decode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>6180eef617ae941497ee78e40e5e6342</anchor>
      <arglist>(apreq_param_t **param, apr_pool_t *pool, const char *word, apr_size_t nlen, apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_param_encode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>02630e21751e52a581617abf10281b2f</anchor>
      <arglist>(apr_pool_t *pool, const apreq_param_t *param)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_query_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>b916a32c498eb9cd0afa0a08fa1719e0</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *t, const char *qs)</arglist>
    </member>
    <member kind="function">
      <type>apr_array_header_t *</type>
      <name>apreq_params_as_array</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>7c124a132cbf38676d0b7cf4a7ae583b</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_params_as_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>92d8df1c7a7b04ec535b6c6fa8bea64d</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>const apr_table_t *</type>
      <name>apreq_uploads</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>93a38cd9efe828ef983b37ec52a9c80d</anchor>
      <arglist>(const apr_table_t *body, apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>const apreq_param_t *</type>
      <name>apreq_upload</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>2e68b957b89e25d529edf98d7703812f</anchor>
      <arglist>(const apr_table_t *body, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_parser.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__parser_8h</filename>
    <includes id="apreq__param_8h" name="apreq_param.h" local="yes" imported="no">apreq_param.h</includes>
    <class kind="struct">apreq_hook_t</class>
    <class kind="struct">apreq_parser_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PARSER_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>57c75d9de5ddbaa09ef4bf4cbeb04846</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_HOOK_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>15e8bd037103bdb92023abf30f18252c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>35abd6d504c1132860e6dff2bdd5037c</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>761ba91c1ebf82fc000cccac14cb83c0</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="typedef">
      <type>apreq_hook_t</type>
      <name>apreq_hook_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>4ff45ca22a9e7fbece8ac78b0d233f8b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apreq_parser_t</type>
      <name>apreq_parser_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>018e4ac2eb5d048ee53a12814d329a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_parser_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>4855e862e92d6bda51b584a60ac873b6</anchor>
      <arglist>)(APREQ_PARSER_ARGS)</arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_hook_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>6469eec81426802ee44ba4ecb5f72e66</anchor>
      <arglist>)(APREQ_HOOK_ARGS)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>3775abf5fb4c9ea97352f2f8f9b59d63</anchor>
      <arglist>(struct apreq_parser_t *psr, apr_table_t *t, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>29efcfea1381bde2dfcb6ae4acbd0770</anchor>
      <arglist>(struct apreq_hook_t *h, apreq_param_t *param, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>6d36d013e41e64a0b213759bb224616c</anchor>
      <arglist>(apreq_parse_headers)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a49de48e077f9b4c84ea004afe54a515</anchor>
      <arglist>(apreq_parse_urlencoded)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>4f23cc70b95b215c8e2e82b3d23b50b2</anchor>
      <arglist>(apreq_parse_multipart)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>d007b83a760665cbb52c13221e3518a3</anchor>
      <arglist>(apreq_parse_generic)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>538b3a7b2169ccd31bc92cadcf1855d9</anchor>
      <arglist>(apreq_hook_apr_xml_parser)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_t *</type>
      <name>apreq_parser_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>59573b2fa86b5f386f2174ce1f179d9c</anchor>
      <arglist>(apr_pool_t *pool, apr_bucket_alloc_t *ba, const char *content_type, apreq_parser_function_t pfn, apr_size_t brigade_limit, const char *temp_dir, apreq_hook_t *hook, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apreq_hook_t *</type>
      <name>apreq_hook_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>d877ef1648f4e2033c4975dafa14f4e3</anchor>
      <arglist>(apr_pool_t *pool, apreq_hook_function_t hook, apreq_hook_t *next, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parser_add_hook</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>78090b5e588a759c54c8c356b6765fe2</anchor>
      <arglist>(apreq_parser_t *p, apreq_hook_t *h)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_function_t</type>
      <name>apreq_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>68e9aa1a682757a7fb30a75ca9b271f3</anchor>
      <arglist>(const char *enctype)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_register_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>1a91fcc48c6f653947f47f47991b3855</anchor>
      <arglist>(const char *enctype, apreq_parser_function_t pfn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>b5f3ad7a219a17afd6be39aeacdb2967</anchor>
      <arglist>(apreq_hook_disable_uploads)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>dd6658efc88dded078107a931763233c</anchor>
      <arglist>(apreq_hook_discard_brigade)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a3729893302ad19d6ead8a6da00000c8</anchor>
      <arglist>(apreq_hook_find_param)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_util.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__util_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="function">
      <type>char *</type>
      <name>apreq_join</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>d1c7e78620dd2b0563b1c1df592e43e7</anchor>
      <arglist>(apr_pool_t *p, const char *sep, const apr_array_header_t *arr, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>apr_ssize_t</type>
      <name>apreq_index</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ec5bf42057db2740a0e5a0eb2e755faa</anchor>
      <arglist>(const char *hay, apr_size_t hlen, const char *ndl, apr_size_t nlen, const apreq_match_t type)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>f8892e789ab4cfb1ebdba840029f3dfa</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote_once</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>8499b03a42041896c5493153a42ceaea</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_encode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>74bbf602809048452bbdbe886ceef023</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_cp1252_to_utf8</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>08e187fa5b4ab0e266d1181a9a339ad9</anchor>
      <arglist>(char *dest, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apreq_charset_t</type>
      <name>apreq_charset_divine</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>0db5346289e60c92a1f872a83616d545</anchor>
      <arglist>(const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>3ba952bafd216993aa6179c54cc8f7fc</anchor>
      <arglist>(char *dest, apr_size_t *dlen, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decodev</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>2b2b282bcd131600809b57e209fee55b</anchor>
      <arglist>(char *dest, apr_size_t *dlen, struct iovec *v, int nelts)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE char *</type>
      <name>apreq_escape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>3dbf930c2513c2cc8c3cd0e2a2aae05a</anchor>
      <arglist>(apr_pool_t *p, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_ssize_t</type>
      <name>apreq_unescape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>21b07faae90ae081971ff8cc9a067610</anchor>
      <arglist>(char *str)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64f</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>88965cc51e12335ff18f2b88ccb6a719</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64t</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>d72c27a9b4236dc731bb9a8abe5c142a</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_fwrite</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>2f435b1e9ceae84cf8940d6932602695</anchor>
      <arglist>(apr_file_t *f, apr_off_t *wlen, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_file_mktemp</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>16f1553486cb760816988839204d8118</anchor>
      <arglist>(apr_file_t **fp, apr_pool_t *pool, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_setaside</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>8b5ee377aa7737645c7f8b3490d52bc0</anchor>
      <arglist>(apr_bucket_brigade *bb, apr_pool_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_copy</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>340835cf6c45fd8285ce90c8f33c8d4c</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_brigade_move</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>7dfe93c46a753d87565115d15f47f892</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s, apr_bucket *e)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_header_attribute</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>51e7a21aeccdb0b1049235d202ff65b6</anchor>
      <arglist>(const char *hdr, const char *name, const apr_size_t nlen, const char **val, apr_size_t *vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_concat</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>9bc48f8f251b9a12007a7306525af0a3</anchor>
      <arglist>(apr_pool_t *pool, const char *temp_dir, apr_size_t brigade_limit, apr_bucket_brigade *out, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apr_file_t *</type>
      <name>apreq_brigade_spoolfile</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>7a45fb1d8337ea97431133deb83354c2</anchor>
      <arglist>(apr_bucket_brigade *bb)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_version.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__version_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MAJOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>7a40049b3aa9b2fbf7ff0808952eb1bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MINOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>6134073d61c1af512b3e3317d422b4da</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PATCH_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>5955552a28011b51674fb3843af52ece</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_VERSION_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>f300520c1fa54c480b11ae517c912649</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_IS_DEV_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>2ff1ad65c4869e646d00212eb99ac9ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_version</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>800136414e80f1c8cc29670dbd201fa6</anchor>
      <arglist>(apr_version_t *pvsn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_version_string</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>e477ebf18b05b8eeb43b3bf9d83dc970</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_cookie_t</name>
    <filename>structapreq__cookie__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>path</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>4745e0c63dcd31baa6703dc4ed64b53b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>domain</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>7c3a1af6c286246ff4fc2c1f4b2abf9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>port</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>ead6370f8a3d937ecbf69e2fcfa71cb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>comment</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>86ddc110bc4ade8fd2caec3bf4fa66b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>commentURL</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>540294d3bd793f7653c83343131bb1ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_time_t</type>
      <name>max_age</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>0452e1d76efa339c5afa55992c5bce10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>79cab1aea4c1900b799cd63da9168e57</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>47d132128ac959e74a5b1797fb2a8f6e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_handle_t</name>
    <filename>structapreq__handle__t.html</filename>
    <member kind="variable">
      <type>const struct apreq_module_t *</type>
      <name>module</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>55b7b05a623071af06c8f289c0cc41a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>80068548da828f7c4e3dc265ecfc41e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>f282ca5d5ad56e4085ee165f90aae596</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_hook_t</name>
    <filename>structapreq__hook__t.html</filename>
    <member kind="variable">
      <type>apreq_hook_function_t</type>
      <name>hook</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>9e0d8e03901f21e9d16867a217fcefa3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>next</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>46f0a8bc0503af2156939c24cb1c1624</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>ddfd23393300924447de84f1016f0cbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>503d399721c88f4a37997e50bb4b2638</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_module_t</name>
    <filename>structapreq__module__t.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>b32684e819a242536cad3118d52dcf90</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_uint32_t</type>
      <name>magic_number</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>2ff1482603546104cb7b5bb5651f352f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>jar</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>76c838ab71d675ac6b620258d356fdc1</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>args</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>9b958eaafd129279d8ad55243921c7d7</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>body</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a614f35761838febdfe693d0ddbc4b7c</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_cookie_t *(*</type>
      <name>jar_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>b5e8790aebf2e6548fbb864e7fee8e59</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>args_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>d2c4b8d357b722e7dd7379001fa05ed9</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>body_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>3cce87e692ce89a18e789f8a2c0c6a03</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>6ed2c8845f51a497f05a85aa6a6ca700</anchor>
      <arglist>)(apreq_handle_t *, const apreq_parser_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>5eb7bb6a8f5818c77ebc2f9a7c5730fc</anchor>
      <arglist>)(apreq_handle_t *, apreq_parser_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>hook_add</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>2f413a5aaaae6e83fc3ca9b8212327c4</anchor>
      <arglist>)(apreq_handle_t *, apreq_hook_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>924ab03cf2c4a2d0ed66c59d1624ee27</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>298e6be980844d3735f3cce56effd62b</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>84d5b24aa938ecc52a37c68098be1fa1</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>66050710752c483bca9a342386d2e008</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>1ce87d1ed4a7dc4077457f43d9fb4266</anchor>
      <arglist>)(apreq_handle_t *, const char **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>b6c1bbcb4dd9f5934e8632718664715b</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_param_t</name>
    <filename>structapreq__param__t.html</filename>
    <member kind="variable">
      <type>apr_table_t *</type>
      <name>info</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>a96e72eaf7df7e6f35f06f687fdaecdf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_brigade *</type>
      <name>upload</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>523938d46435b9d40c44ac83423424fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>3004a7ff6033c21543eab6beb39151a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>5fe7352c78ca6c11d12a98cad37711b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_parser_t</name>
    <filename>structapreq__parser__t.html</filename>
    <member kind="variable">
      <type>apreq_parser_function_t</type>
      <name>parser</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>f72f150bb8f1910a732e0af9dcd5a1b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>content_type</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>cf262801e8cb55fc8839557d5b0dd5a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>97a65f4d0e0d9c8d4474d276364f4aee</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>96731d8dff295e94e7ab4ebe994e5d34</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>brigade_limit</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>25ede91d56d3b6824760512cadf9c9b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>temp_dir</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>e40c14ade28e37e188c05e92c9f9da51</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>hook</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>1b8dd2136ae2cb5defccfa44dbb77ebc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>04db922c73dfb26c9387235bd4534fd5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_value_t</name>
    <filename>structapreq__value__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>4b3b035cc3f8b1b91820bf83bf517004</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>nlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>6cc4ce6e55bcf70adf0c74d59af33b06</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>dlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>1ba183deabfd089ecbc7150fac50c986</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>data</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>63b02e49a0e4d6473af0d1f92b5e9bf1</anchor>
      <arglist>[1]</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>apreq_changes</name>
    <title>CHANGES</title>
    <filename>apreq_changes</filename>
    <docanchor file="apreq_changes">v2_07</docanchor>
    <docanchor file="apreq_changes">v2_0_0</docanchor>
    <docanchor file="apreq_changes">v2_01_dev</docanchor>
    <docanchor file="apreq_changes">v2_02_dev</docanchor>
    <docanchor file="apreq_changes">v2_03_dev</docanchor>
    <docanchor file="apreq_changes">v2_04_dev</docanchor>
    <docanchor file="apreq_changes">v2_05_dev</docanchor>
    <docanchor file="apreq_changes">v2_06_dev</docanchor>
  </compound>
  <compound kind="page">
    <name>apreq_status</name>
    <title>STATUS</title>
    <filename>apreq_status</filename>
  </compound>
  <compound kind="page">
    <name>apreq_license</name>
    <title>LICENSE</title>
    <filename>apreq_license</filename>
  </compound>
  <compound kind="page">
    <name>apreq_notice</name>
    <title>NOTICE</title>
    <filename>apreq_notice</filename>
  </compound>
  <compound kind="page">
    <name>apreq_install</name>
    <title>INSTALL</title>
    <filename>apreq_install</filename>
  </compound>
  <compound kind="group">
    <name>libapreq2</name>
    <title>Apache Request Library</title>
    <filename>group__libapreq2.html</filename>
    <file>apreq.h</file>
    <file>apreq_cookie.h</file>
    <file>apreq_error.h</file>
    <file>apreq_module.h</file>
    <file>apreq_param.h</file>
    <file>apreq_parser.h</file>
    <file>apreq_util.h</file>
    <file>apreq_version.h</file>
    <docanchor file="group__libapreq2">apreq2_config</docanchor>
  </compound>
  <compound kind="group">
    <name>apreq_module</name>
    <title>Modules</title>
    <filename>group__apreq__module.html</filename>
    <subgroup>mod_apreq2</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_lang</name>
    <title>Language Bindings</title>
    <filename>group__apreq__lang.html</filename>
  </compound>
  <compound kind="group">
    <name>mod_apreq2</name>
    <title>Apache 2.X Filter Module</title>
    <filename>group__mod__apreq2.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FILTER_NAME</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>gd1d4a8b6cb30061529cbb4c1a07b344f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_APACHE2_MMN</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>g4b6932ca64a46d9d9fe44547c989cd6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_apache2</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>gc203aa6c8aec6d61f116251ea2ba56a0</anchor>
      <arglist>(request_rec *r)</arglist>
    </member>
  </compound>
</tagfile>
