%define name aqbanking
%define version 1.6.1
%define plugindir %{_libdir}/aqbanking/plugins/0

### Optionally disable chipcard and ofx sub-packages - resulting
### rpms should not be released!
%define have_libchipcard 1
%define have_libofx 1

### Define the distribution-specific name parts

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")

# Note: There is not yet a special symbol for the rpm release
# version. We set it to one here.
%define release 1.%{disttag}%{distver}

### Choose backends to be built
%if %have_libofx
%if %have_libchipcard
%define backendlist "aqhbci aqdtaus aqgeldkarte aqofxconnect"
%else
%define backendlist "aqhbci aqdtaus aqofxconnect"
%endif
%else
%if %have_libchipcard
%define backendlist "aqhbci aqdtaus aqgeldkarte"
%else
%define backendlist "aqhbci aqdtaus"
%endif
%endif

### The standard information fields.

Name: %{name}
Summary: A library for online banking functions and financial data import/export.
Version: %{version}
Release: %{release}
Source: http://download.sourceforge.net/aqbanking/%{name}-%{version}.tar.gz
Group: System Environment/Libraries
License: GPL
Packager: Christian Stimming <stimming@tuhh.de>
URL: http://sourceforge.net/projects/aqbanking
BuildRoot: %{_tmppath}/%{name}-%{version}-root
# Note: We might add ktoblzcheck here as well
BuildRequires: gwenhywfar-devel >= 1.15.0
Obsoletes: aqhbci
Obsoletes: aqdtaus
Prereq: /sbin/ldconfig
Prefix: %{_prefix}

%description 
The intention of AqBanking is to provide a middle layer between
the program and the various Online Banking libraries
(e.g. AqHBCI). The first backend which is already supported is
AqHBCI, a library which implements a client for the German HBCI
(Home Banking Computer Interface) protocol. Additionally,
Aqbanking provides various plugins to simplify import and export
of financial data. Currently there are import plugins for the
following formats: DTAUS (German financial format), SWIFT (MT940
and MT942). Further information in German can be found on
http://linuxwiki.de/AqBanking


%package devel
Summary: Aqbanking development kit
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Obsoletes: aqhbci-devel
Obsoletes: aqdtaus-devel
%description devel
This package contains aqbanking-config and header files for writing and
compiling programs using Aqbanking.

%package qt3
Summary: Aqbanking tools for Qt3
Group: System Environment/Libraries
Obsoletes: aqhbci-qt-tools
Obsoletes: aqdtaus-qt-tools
%description qt3
Necessary for all banking applications.

%package gtk2
Summary: Aqbanking tools for Gnome2/Gtk2
Group: System Environment/Libraries
Obsoletes: aqbanking-gnome2
%description gtk2
Necessary for gtk2-based banking applications, e.g. Grisbi (but
not gnucash).

%package kde3
Summary: Aqbanking tools for KDE3
Group: System Environment/Libraries
Requires: aqbanking-qt3
Obsoletes: aqbanking-kde
%description kde3
Necessary for KDE-based banking applications, e.g. KMyMoney.

### Sub-packages for OFX

%if %have_libofx
%package ofx
BuildRequires: libofx >= 0.8.0
Summary: Aqbanking tools for Qt3
Group: System Environment/Libraries
%description ofx
Necessary for OFX direct connect access.

%package ofx-qt3
Summary: Aqbanking tools for Qt3
Group: System Environment/Libraries
%description ofx-qt3
Necessary for OFX direct connect access.
%endif

### Sub-packages for Geldkarte

%if %have_libchipcard
Requires: libchipcard2
BuildRequires: libchipcard2-devel >= 1.9.13
%package geldkarte
Summary: Aqbanking tools for Qt3
Group: System Environment/Libraries
%description geldkarte
Necessary for Geldkarte access.

%package geldkarte-qt3
Summary: Aqbanking tools for Qt3
Group: System Environment/Libraries
%description geldkarte-qt3
Necessary for Geldkarte access.
%endif

### The build commands

%prep
%setup -q

%build
%{configure} --with-backends=%{backendlist} --enable-python
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

### The file list for all packages

%files
%defattr(-,root,root)
%doc AUTHORS README COPYING ChangeLog
### The original aqbanking files
%{_libdir}/libaqbanking*
%{_libdir}/gwenhywfar
%{_datadir}/%{name}/bankinfo
%{_datadir}/locale/*/LC_MESSAGES/%{name}.mo
%{_bindir}/aqbanking-tool
%{_datadir}/doc/%{name}
%{_datadir}/doc/aqhbci
%{plugindir}/bankinfo
%{plugindir}/imexporters/csv.*
%{plugindir}/imexporters/dbio.*
%{plugindir}/imexporters/dtaus.*
%{plugindir}/imexporters/eri.*
%{plugindir}/imexporters/eri2.*
%{plugindir}/imexporters/openhbci1.*
%{plugindir}/imexporters/qif.*
%{plugindir}/imexporters/swift.*
%{_datadir}/%{name}/imexporters/csv
%{_datadir}/%{name}/imexporters/dtaus
%{_datadir}/%{name}/imexporters/eri
%{_datadir}/%{name}/imexporters/eri2
%{_datadir}/%{name}/imexporters/ofx
%{_datadir}/%{name}/imexporters/openhbci1
%{_datadir}/%{name}/imexporters/swift
%{py_sitedir}/%{name}
### The aqhbci files
%{_datadir}/aqhbci
%{_bindir}/aqhbci-tool
%{_libdir}/libaqhbci*
%{plugindir}/providers/aqhbci.*
### The dtaus files
%{_libdir}/libaqdtaus*
%{plugindir}/providers/aqdtaus.*
### The cbanking files
%{_libdir}/libcbanking*

%files qt3
%{_libdir}/libqbanking*
%{plugindir}/wizards/aqhbci
%{plugindir}/debugger/aqhbci
%{plugindir}/wizards/aqdtaus
%{_datadir}/%{name}/i18n

%if %have_libofx
%files ofx
%{plugindir}/providers/aqofxconnect.*
%{_includedir}/aqofxconnect
%{plugindir}/imexporters/ofx.*
%{_datadir}/%{name}/imexporters/ofx
%{_bindir}/aqofxconnect-config
%{_libdir}/libaqofxconnect*
%files ofx-qt3
%{plugindir}/wizards/aqofxconnect
%endif

%if %have_libchipcard
%files geldkarte
%{plugindir}/providers/aqgeldkarte.*
%{_includedir}/aqgeldkarte
%{_bindir}/aqgeldkarte-config
%{_libdir}/libaqgeldkarte*
%files geldkarte-qt3
%{plugindir}/wizards/aqgeldkarte
%endif

%files gtk2
%{_libdir}/libg2banking*

%files kde3
%{_libdir}/libkbanking*

%files devel
%defattr(-,root,root)
### The aqbanking files
%{_includedir}/aqbanking
%{_includedir}/aqbanking++
%{_bindir}/aqbanking-config
%{_libdir}/*.la
%{_libdir}/pkgconfig/aqbanking.pc
%{_datadir}/aclocal
#%{_datadir}/aclocal/aqbanking.m4
### The aqhbci files
%{_includedir}/aqhbci
%{_bindir}/aqhbci-config
%{_bindir}/hbcixml2
#%{_datadir}/aclocal/aqhbci.m4
### The cbanking files
%{_includedir}/cbanking
### The g2banking files
%{_includedir}/g2banking
%{_bindir}/g2banking-config
### The qbanking files
%{_includedir}/qbanking
%{_bindir}/qbanking-config
### The kbanking files
%{_includedir}/kbanking
%{_bindir}/kbanking-config
### The aqdtaus files
%{_includedir}/aqdtaus
%{_bindir}/aqdtaus-config
