/***************************************************************************
 $RCSfile: qt3_wizard.cpp,v $
                             -------------------
    cvs         : $Id: qt3_wizard.cpp,v 1.3 2005/09/19 11:30:17 cstim Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <qapplication.h>
#include <qtranslator.h>
#include <qtextcodec.h>

#include <aqofxconnect/provider.h>
#include <gwenhywfar/logger.h>
#include <gwenhywfar/debug.h>

#include <stdio.h>

#include <qbanking/qbanking.h>
#include "settings.h"




int main(int argc, char **argv) {
  QApplication app(argc, argv);
  QBanking *ab;
  OfxSettings *av;
  int result;
  AB_PROVIDER *pro;
  QTranslator translator(0);

  GWEN_Logger_SetLevel(0, GWEN_LoggerLevelInfo);
  //GWEN_Logger_SetLevel(GWEN_LOGDOMAIN, GWEN_LoggerLevelInfo);
  GWEN_Logger_SetLevel("aqofxconnect", GWEN_LoggerLevelDebug);
  //GWEN_Logger_SetLevel("aqbanking", GWEN_LoggerLevelInfo);

  QString datadir(PKGDATADIR);
  if (translator.load(QTextCodec::locale()+QString(".qm"),
		      datadir + QString("/i18n/"))) {
    DBG_INFO(0, "I18N available for your language");
    app.installTranslator(&translator);
  }
  else {
    DBG_WARN(0, "Internationalisation is not available for your language");
  }

  ab=new QBanking("aqofxconnect-qt-wizard", 0);
  if (ab->init()) {
    fprintf(stderr, "Error on init.\n");
    return 2;
  }

  pro=ab->getProvider("aqofxconnect");
  assert(pro);

  QObject::connect(&app,SIGNAL(lastWindowClosed()),
                   &app,SLOT(quit()));

  av=new OfxSettings(ab);
  av->init();
  app.setMainWidget(av);
  av->show();

  result=app.exec();

  av->fini();

  if (ab->fini()) {
    fprintf(stderr, "Error on fini.\n");
  }
  fprintf(stderr, "FINI done.\n");

  delete av;
  delete ab;

  return 0;
}





