/***************************************************************************
 $RCSfile: medium_p.h,v $
                             -------------------
    cvs         : $Id: medium_p.h,v 1.8 2005/03/08 00:55:52 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AH_MEDIUM_P_H
#define AH_MEDIUM_P_H

#include <aqhbci/medium.h>


struct AH_MEDIUM {
  GWEN_LIST_ELEMENT(AH_MEDIUM);
  GWEN_INHERIT_ELEMENT(AH_MEDIUM);

  AH_HBCI *hbci;
  AH_MEDIUMTYPE mediumType;
  char *mediumName;
  char *mediumTypeName;

  char *descriptiveName;

  GWEN_TYPE_UINT32 showBoxId;

  /* BEGIN: user data */
  char *pSecurityId;
  unsigned int lSecurityId;

  char *peerAddr;
  int peerPort;

  GWEN_TYPE_UINT32 flags;
  /* END: user data */

  AH_MEDIUMDEVICE deviceType;

  GWEN_TYPE_UINT32 mountCount;
  int selectedContext;

  AH_MEDIUM_MOUNTFN mountFn;
  AH_MEDIUM_CREATEFN createFn;
  AH_MEDIUM_UNMOUNTFN unmountFn;

  AH_MEDIUM_CHANGEPINFN changePinFn;
  AH_MEDIUM_TODBFN toDbFn;
  AH_MEDIUM_FROMDBFN fromDbFn;

  AH_MEDIUM_GETNEXTSIGNSEQFN getNextSignSeqFn;
  AH_MEDIUM_SETLOCALSIGNSEQFN setLocalSignSeqFn;

  AH_MEDIUM_SIGNFN signFn;
  AH_MEDIUM_VERIFYFN verifyFn;

  AH_MEDIUM_DECRYPTKEYFN decryptKeyFn;
  AH_MEDIUM_ENCRYPTKEYFN encryptKeyFn;
  AH_MEDIUM_GENERATEMSGKEYFN generateMsgKeyFn;

  AH_MEDIUM_SELECTCONTEXTFN selectContextFn;
  AH_MEDIUM_CREATECONTEXTFN createContextFn;
  AH_MEDIUM_REMOVECONTEXTFN removeContextFn;

  AH_MEDIUM_READCONTEXTFN readContextFn;
  AH_MEDIUM_WRITECONTEXTFN writeContextFn;

  GWEN_KEYSPEC *localSignKeySpec;
  GWEN_KEYSPEC *localCryptKeySpec;

  GWEN_KEYSPEC *remoteSignKeySpec;
  GWEN_KEYSPEC *remoteCryptKeySpec;

  GWEN_TYPE_UINT32 usage;
  GWEN_TYPE_UINT32 linkCount;

  int isDirty;
};


void AH_Medium__AddMediumInfo(AH_MEDIUM *m, GWEN_BUFFER *mbuf);



struct AH_MEDIUMPROVIDER {
  GWEN_LIST_ELEMENT(AH_MEDIUMPROVIDER);
  GWEN_INHERIT_ELEMENT(AH_MEDIUMPROVIDER);

  AH_HBCI *hbci;
  char *mediumTypeName;

  GWEN_LIBLOADER *libLoader;

  char *description;

  AH_MEDIUMDEVICE deviceType;

  AH_MEDIUMPROVIDER_FACTORYFN factoryFn;
  AH_MEDIUMPROVIDER_CHECKFN checkFn;
};




#endif /* AH_MEDIUM_P_H */


