

#include <gwenhywfar/logger.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/debug.h>

#include <aqhbci/hbci.h>
#include <gwenhywfar/logger.h>
#include <gwenhywfar/debug.h>
#include <aqbanking/banking_be.h>


#include "cbanking.h"




int decodeWithMedium(int argc, char **argv) {
  GWEN_DB_NODE *dbData;
  const char *dataFileName;
  const char *mediumName;
  const void *p;
  unsigned int len;
  GWEN_BUFFER *msgbuf;
  GWEN_BUFFER *dbuf;
  GWEN_BUFFER *dbuf1;
  GWEN_BUFFER *dbuf2;
  GWEN_BUFFER *tbuf1;
  GWEN_BUFFER *tbuf2;
  AH_MEDIUM *m;
  AH_HBCI *hbci;
  AB_BANKING *ab;
  AB_PROVIDER *provider;
  int rv;
  AH_MEDIUM_RESULT mres;

  if (argc<4) {
    fprintf(stderr, "Usage: %s DATAFILE MEDIUMFILE\n", argv[0]);
    return 1;
  }
  GWEN_Logger_SetLevel(0, GWEN_LoggerLevelInfo);

  dataFileName=argv[2];
  mediumName=argv[3];

  ab=CBanking_new("aqtest", 0);
  rv=AB_Banking_Init(ab);
  if (rv) {
    DBG_ERROR(0, "Error on init (%d)", rv);
    AB_Banking_free(ab);
    return 2;
  }
  provider=AB_Banking_GetProvider(ab, "aqhbci");
  hbci=AH_HBCI_new(provider);
  m=AH_HBCI_SelectMedium(hbci, "ohbci", mediumName);
  if (!m) {
    DBG_ERROR(0, "Could not select medium.");
    AB_Banking_Fini(ab);
    AB_Banking_free(ab);
    return 2;
  }

  dbData=GWEN_DB_Group_new("data");
  if (GWEN_DB_ReadFile(dbData, dataFileName,
		       GWEN_DB_FLAGS_DEFAULT |
		       GWEN_PATH_FLAGS_CREATE_GROUP)) {
    fprintf(stderr, "Could not read data file \"%s\"\n", dataFileName);
    return 2;
  }

  dbuf=GWEN_Buffer_new(0, 256, 0, 1);
  dbuf1=GWEN_Buffer_new(0, 256, 0, 1);
  dbuf2=GWEN_Buffer_new(0, 256, 0, 1);
  p=GWEN_DB_GetBinValue(dbData, "MsgKey", 0, 0, 0, &len);
  if (!p || !len) {
    fprintf(stderr, "No data found\n");
    return 2;
  }
  GWEN_Buffer_AppendBytes(dbuf, (const char*)p, len);
  if (len<96) {
    /* try to append behind */
    GWEN_Buffer_AppendBuffer(dbuf1, dbuf);
    GWEN_Buffer_FillWithBytes(dbuf1, 0, 96-len);
    /* try to append before */
    GWEN_Buffer_FillWithBytes(dbuf2, 0, 96-len);
    GWEN_Buffer_AppendBuffer(dbuf2, dbuf);
  }
  else {
    GWEN_Buffer_AppendBuffer(dbuf1, dbuf);
    GWEN_Buffer_AppendBuffer(dbuf2, dbuf);
  }

  msgbuf=GWEN_Buffer_new(0, 1024, 0, 1);
  p=GWEN_DB_GetBinValue(dbData, "CryptData", 0, 0, 0, &len);
  if (!p || !len) {
    fprintf(stderr, "No data found\n");
    return 2;
  }
  GWEN_Buffer_AppendBytes(msgbuf, (const char*)p, len);


  DBG_NOTICE(0, "Mounting medium");
  rv=AH_Medium_Mount(m);
  if (rv) {
    DBG_ERROR(0, "Error on mount (%d)", rv);
    AB_Banking_Fini(ab);
    AB_Banking_free(ab);
    return 2;
  }
  DBG_NOTICE(0, "Mounted medium");

  rv=AH_Medium_SelectContext(m, 0);
  if (rv) {
    DBG_ERROR(0, "Error on SelectContext (%d)", rv);
    AH_Medium_Unmount(m, 1);
    AB_Banking_Fini(ab);
    AB_Banking_free(ab);
    return 2;
  }
  DBG_NOTICE(0, "Selected context");

  tbuf1=GWEN_Buffer_new(0, 1024, 0, 1);
  GWEN_Buffer_Rewind(msgbuf);
  GWEN_Buffer_Rewind(dbuf1);
  mres=AH_Medium_DecryptKey(m, dbuf1, tbuf1);
  if (mres!=AH_MediumResultOk) {
    DBG_ERROR(0, "Error decoding the message");
  }
  else {
    DBG_ERROR(0, "Decoding ok.");
  }

  tbuf2=GWEN_Buffer_new(0, 1024, 0, 1);
  GWEN_Buffer_Rewind(msgbuf);
  GWEN_Buffer_Rewind(dbuf2);
  mres=AH_Medium_DecryptKey(m, dbuf2, tbuf2);
  if (mres!=AH_MediumResultOk) {
    DBG_ERROR(0, "Error decoding the message");
  }
  else {
    DBG_ERROR(0, "Decoding ok.");
  }

  DBG_NOTICE(0, "Unmounting medium");
  rv=AH_Medium_Unmount(m, 1);
  if (rv) {
    DBG_ERROR(0, "Error on unmount (%d)", rv);
    AB_Banking_Fini(ab);
    AB_Banking_free(ab);
    return 2;
  }
  DBG_NOTICE(0, "Unmounted medium");

  if (GWEN_Buffer_GetUsedBytes(tbuf1)) {
    GWEN_DB_SetBinValue(dbData, GWEN_DB_FLAGS_OVERWRITE_VARS,
			"tbuf1",
			GWEN_Buffer_GetStart(tbuf1),
			GWEN_Buffer_GetUsedBytes(tbuf1));
  }
  if (GWEN_Buffer_GetUsedBytes(tbuf2)) {
    GWEN_DB_SetBinValue(dbData, GWEN_DB_FLAGS_OVERWRITE_VARS,
			"tbuf2",
			GWEN_Buffer_GetStart(tbuf2),
			GWEN_Buffer_GetUsedBytes(tbuf2));
  }

  GWEN_DB_WriteFile(dbData, "msg.out", GWEN_DB_FLAGS_DEFAULT);

  return 0;
}



int execOutBox(int argc, char **argv) {
  AB_BANKING *ab;
  int rv1;
  int rv2;

  GWEN_Logger_SetLevel(0, GWEN_LoggerLevelInfo);

  ab=CBanking_new("aqtest", 0);
  CBanking_SetCharSet(ab, "ISO-8859-15");

  rv1=AB_Banking_Init(ab);
  if (rv1) {
    DBG_ERROR(0, "Error on init (%d)", rv1);
    AB_Banking_free(ab);
    return 2;
  }

  rv1=AB_Banking_ExecuteQueue(ab);
  rv2=AB_Banking_Fini(ab);

  if (rv1) {
    fprintf(stderr, "ERROR: Error executing the queue (%d)\n", rv1);
    return 3;
  }
  if (rv2) {
    fprintf(stderr, "ERROR: Error on deinit (%d)\n", rv2);
    return 4;
  }

  return 0;
}


int main(int argc, char **argv) {
  int rv;

  GWEN_Logger_SetLevel(GWEN_LOGDOMAIN, GWEN_LoggerLevelError);

  GWEN_Logger_Open("test", "test", 0,
                   GWEN_LoggerTypeConsole,
                   GWEN_LoggerFacilityUser);
  GWEN_Logger_SetLevel("test", GWEN_LoggerLevelDebug);

  DBG_DEBUG("test", "Logging to test");

  if (argc<2) {
    fprintf(stderr, "Command needed.\n");
    return 1;
  }

  if (strcasecmp(argv[1], "decode")==0)
    rv=decodeWithMedium(argc, argv);
  else if (strcasecmp(argv[1], "exec")==0)
    rv=execOutBox(argc, argv);
  else {
    fprintf(stderr, "Unknown command \"%s\"", argv[1]);
    rv=1;
  }

  return rv;
}



