# -*- rpm-spec -*-
#===============================================================================
#
# ASSA library spec.in file.
#
# RPM format: name-version-release.rpm
#
# $Id: assa.spec.in,v 1.15 2005/10/22 20:20:07 vlg Exp $
#===============================================================================

%define debug_package %{nil}

%define rel           1
%define disttag       fc2
%define release       %{rel}.%{disttag}

Summary: 	A C++ network-oriented OO application framework 
Name: 		libassa
Version: 	3.4.0
Release: 	%{release}
Copyright:	LGPL
Group: 		System Environment/Libraries
Packager:	Vladislav Grinchenko (vld@users.sourceforge.net)
Vendor:     3rdShift, Inc.
Source: 	%{name}-%{version}.tar.gz
URL: 		http://libassa.sourceforge.net/
Prefix: 	/usr
BuildRoot: 	/tmp/%{name}-%{version}-root

#===============================================================================
# libassa package 
#===============================================================================

%description
This package is a C++ framework for writing network-based server and
client applications. It is a non-threaded implementation of Adaptive 
Communication Environment design patterns such as Reactor, Connector, 
Acceptor and others.

#===============================================================================
# libassa-devel package 
#===============================================================================

%package	devel
Summary: 	Headers for developing programs with libassa library
Group: 		Development/Libraries

%description devel
This package contains the headers that programmers will need to develop
applications which will use libassa Library.

#===============================================================================
# libassa-devel package 
#===============================================================================

%package	doc
Summary: 	HTML formatted API documentation for libassa library.
Group: 		Development/Libraries

%description doc
This package contains Doxygen-generated class reference of libassa Library.

#===============================================================================
# preparation section
#===============================================================================

%prep
%setup -q

#===============================================================================
# build section
#===============================================================================

%build

# Needed for snapshot releases (autogen.sh vs. configure)

if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" \
		./autogen.sh $ARCH_FLAGS \
			--prefix=%{prefix} \
			--disable-static \
			--enable-shared
else
	CFLAGS="$RPM_OPT_FLAGS" \
		./configure  $ARCH_FLAGS \
			--prefix=%{prefix} \
			--disable-maintainer-mode \
			--disable-static \
			--enable-shared
fi

make

#===============================================================================
# install section
#===============================================================================

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
make DESTDIR=$RPM_BUILD_ROOT install

# new redhat versions don't use .la
rm -f %{buildroot}%{_libdir}/*.la

%post
/sbin/ldconfig
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir 2>/dev/null || :

%preun
if [ $1 = 0 ]; then
  /sbin/install-info --delete %{_infodir}/%{name}.info \
    %{_infodir}/dir 2>/dev/null || :
fi

%postun
/sbin/ldconfig

#===============================================================================
# clenup section
#===============================================================================

%clean
rm -rf $RPM_BUILD_ROOT

#===============================================================================
# files that go into libassa package
#===============================================================================

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog INSTALL NEWS README

%{prefix}/lib/*.so.*

#===============================================================================
# files that go into libassa-devel package
#===============================================================================

%files  devel
%defattr(-, root, root, 755)

%doc  AUTHORS COPYING ChangeLog INSTALL NEWS README

%{prefix}/bin/*
%{prefix}/include/assa
%{prefix}/lib/pkgconfig/*.pc
%{prefix}/lib/*.so
%{prefix}/share/doc/%{name}-%{version}/*

#===============================================================================
# files that go into libassa-doc package
#===============================================================================

%files doc
%doc doc/html

#===============================================================================
%changelog
* Sun Mar 20 2005 Vladislav Grinchenko <vlg@users.sourceforge.net>
- add distribution tag

* Tue Mar  1 2005 Vladislav Grinchenko <vlg@users.sourceforge.net>
- fix documentation installation error

* Sun Dec 12 2004 Vladislav Grinchenko <vlg@users.sourceforge.net>
- fix postrun spelling error

* Tue Aug  6 2002 Vladislav Grinchenko <vladg@erols.com>
- first public release

