//
//  libavg - Media Playback Engine. 
//  Copyright (C) 2003-2008 Ulrich von Zadow
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Current versions can be found at www.libavg.de
//

#ifndef _IDemuxer_H_
#define _IDemuxer_H_

#include "../api.h"
#include <math.h>

#ifdef _WIN32
#define EMULATE_INTTYPES
#else
#ifndef __STDC_CONSTANT_MACROS
#define __STDC_CONSTANT_MACROS
#endif
/*
// XXX Do we still need this?
// This is probably GCC-specific.
#if !defined INT64_C
#if defined __WORDSIZE && __WORDSIZE == 64
#define INT64_C(c) c ## L
#else
#define INT64_C(c) c ## LL
#endif
#endif
*/
#endif

extern "C" {
#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4244)
#endif
#ifdef HAVE_LIBAVFORMAT_AVFORMAT_H
#include <libavformat/avformat.h>
#else
#include <ffmpeg/avformat.h>
#endif
#ifdef _WIN32
#pragma warning(pop)
#endif
}

#include <boost/shared_ptr.hpp>

namespace avg {

    class AVG_API IDemuxer {
        public:
            virtual ~IDemuxer() {};
           
            virtual AVPacket * getPacket(int StreamIndex) = 0;
            virtual void seek(double DestTime) = 0;
            virtual void dump() {};
            
    };
    typedef boost::shared_ptr<IDemuxer> IDemuxerPtr;
}

#endif
