/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "mock-logger.h"

struct _MockLoggerPrivate {
	gpointer unused;
};

G_DEFINE_TYPE (MockLogger, mock_logger, G_TYPE_OBJECT);

static void
mock_logger_init (MockLogger* self)
{
	self->priv = G_TYPE_INSTANCE_GET_PRIVATE (self, MOCK_TYPE_LOGGER, MockLoggerPrivate);
}

static void
mock_logger_class_init (MockLoggerClass* self_class)
{
	g_type_class_add_private (self_class, sizeof (MockLoggerPrivate));
}

MockLogger*
mock_logger_new (gchar const* domain)
{
	return g_object_new (MOCK_TYPE_LOGGER, NULL);
}

gchar const*
mock_logger_get_domain (MockLogger const* self)
{
	return NULL;
}

void
mock_logger_log_fail (gchar const* domain,
		      GLogLevelFlags log_level,
		      gchar const* message,
		      gpointer     user_data)
{
	gboolean* passed = user_data;

	/* this handler is not supposed to be called */
	*passed = FALSE;
}

