/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-unit.h"

#include <ccc/cc-unit.h>

START_TEST(test_unit_simple)
{
	CcDistance* distance = cc_distance_new (5.0, CC_UNIT_DISPLAY_PIXEL);
	cc_distance_free (distance);
}
END_TEST

TCase*
test_unit_allocation (void)
{
	/* FIXME: implement a test that checks the different unit types based
	 * upon GType introspection */
	TCase* self = tcase_create ("Memory Management");
	tcase_add_test (self, test_unit_simple);
	return self;
}

