#!/usr/bin/perl
use strict;
use warnings;
use Carp;
use File::Copy;

# The ProtectCSRF plugin has an bug in its upstream packaging
# which means that originally it did not build correctly.
# This script moves things around to rectify that.

my $dir = glob 'build-area/02/CGI-Application-Plugin-ProtectCSRF-*';
mkdir "$dir/lib" or croak "could not create lib dir";
move("$dir/CGI", "$dir/lib/CGI") or croak "could not move CGI dir";

modify_file("$dir/Makefile.PL", q{FROM\s+=>\s+'CGI/}, q{FROM => 'lib/CGI/});
modify_file("$dir/t/perlcritic.t", q{"CGI/}, q{"lib/CGI/});
modify_file("$dir/t/pod.t", q{"CGI/}, q{"lib/CGI/});

sub modify_file {
    my ($file, $from_str, $to_str) = @_;
    use autodie qw(close open);
    open my $fh, "<", $file;
    my @lines = <$fh>;
    close $fh;
    foreach my $line (@lines) {
        $line =~ s{$from_str}{$to_str}xms;
    }
    chmod 0644, $file or croak "could not make $file writeable";
    open $fh, ">", $file;
    print {$fh} @lines;
    close $fh;
}

# Copyright 2010, Nicholas Bamber <nicholas@periapt.co.uk>

