# $Id: kde2.m4,v 1.2 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for KDE 2


AC_DEFUN(AQ_CHECK_KDE2,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if KDE2 is needed, "no" if KDE2 is optional
dnl   $2 = subdirs to include when KDE2 is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_kde2 - set to "yes" if KDE2 exists
dnl     kde2_includes - CFLAGS for includes (-I)
dnl     kde2_include_dir - path to includes
dnl     kde2_libs - LDFLAGS for linking the kde3 libraries (-L)
dnl     kde2_app - kde2 apps given as the argument to this funtion
dnl     kde2_install_dir - install directory for kde3 applications
dnl   Defines:
dnl     HAVE_KDE2
dnl USED MACROS:
dnl  AQ_CHECK_QT2


kde2_local_lforce="$1"
kde2_local_lsd="$2"

AC_MSG_CHECKING(if KDE2 is allowed)
AC_ARG_ENABLE(kde2,
  [  --enable-kde2         enable kde2 (default=yes)],
  enable_kde2="$enableval",
  enable_kde2="yes")
AC_MSG_RESULT($enable_kde2)

if test "$enable_kde2" = "no"; then
   kde2_libs=""
   kde2_includes=""
   kde2_include_dir=""
   kde2_app=""
   kde2_install_dir=""
else


dnl check for QT2
AQ_CHECK_QT2("$kde2_local_lforce")
AC_MSG_CHECKING(if qt2 version is fully useable)
if test "$have_qt2" != "yes"; then
   	kde2_libs=""
   	kde2_includes=""
   	kde2_include_dir=""
   	kde2_app=""
   	kde2_install_dir=""
	AC_MSG_RESULT(no, so no KDE2 without qt2)
else
	AC_MSG_RESULT(yes)



dnl paths for kde install dir
AC_MSG_CHECKING(for kde2 install dir)
AC_ARG_WITH(kde2-prefix, 
  [  --with-kde2-prefix=DIR      installs kde2 apps to the given dir],
  [local_kde2_prefix="$withval"],
  [local_kde2_prefix="\
  	$KDEDIR \
        /usr/local \
        /usr \
        /opt/kde2 \
        /opt/kde \
        "
  ]
)

if test -z "$kde2_install_dir"; then
	for i in $local_kde2_prefix; do
		if test -z "$kde2_install_dir"; then
        	   if test -x "$i/bin/kde-config"; then
                   	if $i/bin/kde-config --prefix &>/dev/null ; then
                           kde2_install_dir="`$i/bin/kde-config --prefix`"
                        else
                           tmp="`$i/bin/kde-config --prefix 2>&1`"
                           AC_MSG_WARN([
  $i/bin/kde-config exists, but could not be executed. Error was
  "$tmp]")
  			fi
                   fi
 		fi
        done
fi

if test -z "$kde2_install_dir"; then
      	AC_MSG_RESULT(not found)
else
      	AC_MSG_RESULT($kde2_install_dir)
fi


dnl paths for kde includes
AC_MSG_CHECKING(for kde2 includes)
AC_ARG_WITH(kde2-includes, 
  [  --with-kde2-includes=DIR      uses kde2 includes from given dir],
  [local_kde2_includes="$withval"],
  [local_kde2_includes="\
  	$KDEDIR/include \
        /usr/include/kde2 \
        /usr/local/include/kde2 \
        /usr/include/kde \
        /usr/local/include/kde \
        /opt/kde2/include \
        /opt/kde/include \
        /usr/include \
        /usr/local/include \
        "
  ]
)

if test -z "$kde2_includes"; then
	for i in $local_kde2_includes; do
		if test -z "$kde2_includes"; then
        		if test -r "$i/kapp.h"; then
                        	tmp=`grep "KDE_VERSION_MAJOR 2" "$i/kapp.h"`
                                if test -n "$tmp"; then
                                	kde2_includes="-I$i"
                                        kde2_include_dir="$i"
                                fi
                	fi
 		fi
        done
fi
if test -n "$kde2_includes"; then
	AC_MSG_RESULT($kde2_include_dir)
else
	AC_MSG_RESULT(not found)
fi



dnl paths for kde libs
AC_MSG_CHECKING(for kde libraries)
AC_ARG_WITH(kde2-libs, 
  [  --with-kde2-libs=DIR      uses kde2 libs from given dir],
  [local_kde2_libs="$withval"],
  [local_kde2_libs="\
  	$KDEDIR/lib \
        /usr/lib/kde2 \
        /usr/local/lib/kde2 \
        /usr/lib/kde \
        /usr/local/lib/kde \
        /opt/kde2/lib \
        /opt/kde/lib \
        /usr/lib \
        /usr/local/lib \
        "
  ]
)

if test -z "$kde2_libs"; then
	AQ_SEARCH_FOR_PATH([libkdeui.so.3],[$local_kde2_libs])
       	if test -n "$found_dir" ; then
       		kde2_libs="-L$found_dir"
		AC_MSG_RESULT($kde2_libs)
        else
		AC_MSG_RESULT(not found)
       	fi
fi


# check if all necessary kde components where found
if test -z "$kde2_includes" || \
   test -z "$kde2_install_dir" || \
   test -z "$kde2_libs"; then
	kde2_libs=""
   	kde2_includes=""
   	kde2_app=""
   	if test "$kde2_local_lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of KDE applications is enabled but I could not find some KDE
 components (see which are missing in messages above).
 If you don't want to compile KDE applications please use "--disable-kdeapps".
 ])
   	else
        	AC_MSG_WARN([
 KDE2 is not explicitly disabled and I could not find some KDE2 components 
 (see which are missing in messages above).
 If you don't want to compile KDE2 applications please use "--disable-kde2".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   kde2_app="$kde2_local_lsd"
   have_kde2=yes
   AC_DEFINE(HAVE_KDE2)
fi


dnl end of if QT2 is useable
fi


dnl end of if "$enable_kdeapps"
fi

AS_SCRUB_INCLUDE(kde2_includes)
AC_SUBST(kde2_app)
AC_SUBST(kde2_libs)
AC_SUBST(kde2_includes)
AC_SUBST(kde2_include_dir)
AC_SUBST(kde2_install_dir)

])



