/***************************************************************************
 $RCSfile: ctreadertrader.cpp,v $
                             -------------------
    cvs         : $Id: ctreadertrader.cpp,v 1.4 2003/05/08 21:47:35 aquamaniac Exp $
    begin       : Wed Apr 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif


#include "ctreadertrader.h"
#include "chameleon/chameleon.h"
#include "chameleon/debug.h"

#include <time.h>


int CTReaderTrader::_responseLoop(int reqid, int timeout) {
  int err;
  int i;
  time_t startTime;
  CallBackResult rv;

  i=0;
  startTime=time(NULL);
  while(1) {
    if (timeout>0) {
      if (difftime(time(NULL),startTime)>=timeout) {
	DBG_NOTICE("Timeout");
	return CHIPCARD_ERROR_NO_MESSAGE;
      }
    }

    rv=callback(i==0);
    if (rv==CallBackAbort) {
      DBG_INFO("Aborted by callback");
      return CHIPCARD_ERROR_ABORTED;
    }

    err=ChipCard_CheckResponse(reqid);
    if (err==CHIPCARD_ERROR_NO_MESSAGE) {
      err=ChipCard_Work();
      if (err!=CHIPCARD_SUCCESS) {
	DBG_NOTICE("Chipcard error %d\n",
		   err);
	if (err==CHIPCARD_ERROR_INTERRUPTED ||
	    err==CHIPCARD_ERROR_NO_TRANSPORT)
	  return err;
      }
      err=ChipCard_CheckResponse(reqid);
    }

    if (err!=CHIPCARD_SUCCESS) {
      if (err!=CHIPCARD_ERROR_NO_MESSAGE) {
	DBG_NOTICE("Chipcard error %d\n",
		   err);
	if (err==CHIPCARD_ERROR_UNREACHABLE ||
	    err==CHIPCARD_ERROR_NO_REQUEST ||
	    err==CHIPCARD_ERROR_INTERRUPTED)
	  return err;
      }
    }
    else {
      return CHIPCARD_SUCCESS;
    }

    // if timeout==0, then the caller doesn't want to wait
    if (!timeout) {
      DBG_VERBOUS("No message");
      return CHIPCARD_ERROR_NO_MESSAGE;
    }
    i++;
  } /* while */

  return CHIPCARD_ERROR_NO_MESSAGE;
}


CTReaderTrader::CTReaderTrader(bool next,
			       unsigned int readerFlags,
			       unsigned int readerFlagsMask,
			       unsigned int status,
			       unsigned int statusMask,
			       unsigned int statusDelta)
:_next(next)
,_readerFlags(readerFlags)
,_readerFlagsMask(readerFlagsMask)
,_status(status)
,_statusMask(statusMask)
,_statusDelta(statusDelta)
,_requestid(-1)
{

}


CTReaderTrader::~CTReaderTrader(){
}



CTError CTReaderTrader::start() {
  int err;

  err=ChipCard_RequestWaitReader(&_requestid,
				 _next,
				 "",
				 _readerFlags,
				 _readerFlagsMask,
				 _status,
				 _statusMask,
				 _statusDelta);
  if (err!=CHIPCARD_SUCCESS) {
    DBG_NOTICE("Chipcard error %d\n",err);
    return CTError("CTReaderTrader::start",
		   k_CTERROR_API, err, 0,
		   "Unable start trading");
  }

  return CTError();
}


CTError CTReaderTrader::stop(){
  int err;

  if (_requestid==-1) {
    DBG_NOTICE("Never started trading");
    return CTError("CTReaderTrader::stop",
		   k_CTERROR_INVALID, 0, 0,
		   "Unable stop trading");
  }
  err=ChipCard_StopWaitReader(_requestid);
  if (err!=CHIPCARD_SUCCESS) {
    DBG_NOTICE("Chipcard error %d\n",err);
    return CTError("CTReaderTrader::stop",
		   k_CTERROR_API, err, 0,
		   "Unable stop trading");
  }
  _requestid=-1;
  return CTError();
}


CTError CTReaderTrader::getNext(CTReaderContext &tctx, int timeout){
  int ltid;
  unsigned int lstatus;
  unsigned int lflags;
  unsigned int lcardid;
  int err;

  if (_requestid==-1) {
    DBG_NOTICE("Never started trading");
    return CTError("CTReaderTrader::getNext",
		   k_CTERROR_INVALID, 0, 0,
		   "No trading in progress");
  }

  err=_responseLoop(_requestid, timeout);
  if (err!=CHIPCARD_SUCCESS) {
    DBG_NOTICE("No response");
    return CTError("CTReadertrader::getNext",
		   k_CTERROR_API, err, 0,
		   "No response");
  }

  err=ChipCard_CheckWaitReader(_requestid,
			       &ltid,
			       &lstatus,
			       &lflags,
			       &lcardid);
  if (err!=CHIPCARD_SUCCESS) {
    DBG_NOTICE("No response");
    return CTError("CTReadertrader::getNext",
		   k_CTERROR_API, err, 0,
		   "Error checking for reader");
  }
  DBG_INFO("Card %d at %08x is available (flags=%04x)",
	   lcardid,
	   (unsigned int)ltid,
	   (unsigned int)lflags);
  tctx=CTReaderContext(ltid, lcardid, lflags, lstatus);
  return CTError();
}


CTError CTReaderTrader::peekNext(int timeout) {
  int err;

  if (_requestid==-1) {
    DBG_NOTICE("Never started trading");
    return CTError("CTReaderTrader::peek",
		   k_CTERROR_INVALID, 0, 0,
		   "No trading in progress");
  }

  err=_responseLoop(_requestid, timeout);
  if (err!=CHIPCARD_SUCCESS) {
    DBG_NOTICE("No response");
    return CTError("CTReadertrader::getNext",
		   k_CTERROR_API, err, 0,
		   "No response");
  }

  // ok, there is another response
  return CTError();
}


CTReaderTrader::CallBackResult CTReaderTrader::callback(bool first){
  return CallBackContinue;
}





