/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2008 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file max_vector.hpp
 * \brief Stockage d'une liste d'lments ayant la mme valeur avec majoration.
 * \author Julien Jorge
 */
#ifndef __CLAW_MAX_VECTOR_HPP__
#define __CLAW_MAX_VECTOR_HPP__

#include <vector>

namespace claw
{
  /**
   * \brief Stockage d'une liste d'lments ayant la mme valeur avec
   *        majoration.
   * L'ajout d'un lment de valeur suprieur  la valeur max actuelle supprime
   * tous les lments prsents de la liste.
   * \param E : type des lments  stocker.
   * \author Julien Jorge
   */
  template < class E > class max_vector
  {
  public:
   
    explicit max_vector(const E& e);
    void add(const E& e);
    const std::vector<E>& get_v() const;

  private:
    /** \brief Maximum des lment du vecteur. */
    E m_max;

    /** \brief Les maximums rencontrs. */
    std::vector<E> m_vector;
  }; // max_vector

} // namespace claw

#include <claw/impl/max_vector.tpp>

#endif // __CLAW_MAX_VECTOR_HPP__
