/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2008 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file max_vector.tpp
 * \brief Implmentation de la classe max_vector.
 * \author Julien Jorge
 */

/*---------------------------------------------------------------------------*/
/**
 * \brief Cration avec un lment. 
 * \param e lment ajout.  
 */
template <class E>
claw::max_vector<E>::max_vector(const E& e)
  : m_max(e)
{ 
  m_vector.push_back(e);
} // max_vector() [constructeur]

/*---------------------------------------------------------------------------*/
/**
 * \brief Ajoute un lment dans le vecteur.
 * \param e lment  ajouter. 
 */
template <class E>
void claw::max_vector<E>::add(const E& e)
{
  if ( m_max < e )
    {
      m_vector.clear();       // on dtruit le vecteur
      m_vector.push_back(e);  // on ajoute l'lment
      m_max = e;              // mise  jour du maximum
    }
  else if (e == m_max)
    m_vector.push_back(e);    // on ajoute l'lment
} // add()

/*---------------------------------------------------------------------------*/
/**
 * \brief Renvoie le vecteur.   
 */
template <class E>
const std::vector<E>& claw::max_vector<E>::get_v() const 
{ 
  return m_vector; 
} // get_v()
