/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2010 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file claw.hpp
 * \brief The purpose of this file is to document the namespaces of the library.
 * \author Julien Jorge
 */

/**
 * \brief This is the main namespace.
 */
namespace claw
{
  /**
   * \brief Everything about artificial intelligence.
   */
  namespace ai
  {
    /**
     * \brief Everything about artificial intelligence related game algorithms.
     */
    namespace game
    {
    } // namespace game
  } // namespace ai

  /**
   * \brief Here are the design patterns.
   */
  namespace pattern
  {
  } // namespace pattern

  /**
   * \brief Everything about image structures and processing.
   */
  namespace graphic
  {
  } // namespace image

  /**
   * \brief Manipulation of mathematic, geometric, etc. items.
   */
  namespace math
  {
  } // namespace math

  /**
   * \brief Memory management.
   */
  namespace memory
  {
  } // namespace memory

  /**
   * \brief Structures for meta-programmation.
   */
  namespace meta
  {
  } // namespace meta

  /**
   * \brief Network communications.
   */
  namespace net
  {
  } // namespace net

  /**
   * \brief Everything about text processing.
   */
  namespace text
  {
  } // namespace text
} // namespace claw
