/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.ri.model.dynabeans;

import junit.framework.TestSuite;

import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.TestBean;
import org.apache.commons.jxpath.ri.model.BeanModelTestCase;

/**
 * Test for support of DynaBeans (see BeanUtils)
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.5 $ $Date: 2004/02/29 14:17:44 $
 */

public class DynaBeanModelTest extends BeanModelTestCase {
    public DynaBeanModelTest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(DynaBeanModelTest.class);
//        TestSuite s = new TestSuite();
//        s.addTest(new DynaBeanModelTest("testAxisParent"));
//        return s;
    }

    protected Object createContextBean() {
        return new WrapDynaBean(new TestBean());
    }

    protected AbstractFactory getAbstractFactory() {
        return new TestDynaBeanFactory();
    }
}