/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 7 "complearn-environment.gob"

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <gmodule.h>
#include <libintl.h>
#include "complearn-environment.h"
#include "complearn-environment-private.h"
#include "complearn/clconfig.h"
#include "complearn/aclconfig.h"

#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_ERRNO_H
#include <errno.h>
#endif

#define _(O) gettext(O)

#define PROJECTNAME "complearn"
#define CONFIGNAME (PROJECTNAME ".conf")

static CompLearnEnvironment *cl;
static CompLearnEnvironmentClass *cltc;

static int alphacomp(const void *va, const void *vb)
{
  char **a = (char **) va, **b = (char **) vb;
  return strcmp(*a, *b);
}

static void foreachIncr(GQuark key_id, gpointer data, gpointer user_data)
{
  gint32 *k = (gint32 *) user_data;
  (*k)++;
}

static void foreachNamer(GQuark key_id, gpointer data, gpointer user_data)
{
  char *curname;
  gchar ***k = (gchar ***) user_data;
  CompLearnRealCompressor *rc = data;
  GString *result;
  result = real_compressor_name(COMPLEARN_REAL_COMPRESSOR(rc));
  g_assert(result != NULL);
  g_assert(result->str != NULL);
  curname = result->str;
  g_string_free(result, FALSE);
  (**k) = curname;
  (*k) += 1;
}

void complearn_init(void)
{
  g_type_init();
  complearn_environment_top();
}


#line 83 "complearn-environment.c"
/* self casting macros */
#define SELF(x) COMPLEARN_ENVIRONMENT(x)
#define SELF_CONST(x) COMPLEARN_ENVIRONMENT_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_ENVIRONMENT(x)
#define TYPE_SELF COMPLEARN_TYPE_ENVIRONMENT
#define SELF_CLASS(x) COMPLEARN_ENVIRONMENT_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_ENVIRONMENT_GET_CLASS(x)

/* self typedefs */
typedef CompLearnEnvironment Self;
typedef CompLearnEnvironmentClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void complearn_environment_init (CompLearnEnvironment * o) G_GNUC_UNUSED;
static void complearn_environment_class_init (CompLearnEnvironmentClass * klass) G_GNUC_UNUSED;
static void complearn_environment_load_modules (void) G_GNUC_UNUSED;
static void complearn_environment_load_builtins (void) G_GNUC_UNUSED;
static char * complearn_environment_build_home_filename (const char * inp) G_GNUC_UNUSED;
static void complearn_environment_apply_config_file (const char * fname) G_GNUC_UNUSED;
static char * complearn_environment_build_module_dir_default (void) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MODULE_PATH,
	PROP_VERBOSE,
	PROP_NICE_LEVEL
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new complearn_environment_new
#define self_get_module_path complearn_environment_get_module_path
#define self_set_module_path complearn_environment_set_module_path
#define self_get_verbose complearn_environment_get_verbose
#define self_set_verbose complearn_environment_set_verbose
#define self_get_nice_level complearn_environment_get_nice_level
#define self_set_nice_level complearn_environment_set_nice_level
#define self_top complearn_environment_top
#define self_version complearn_environment_version
#define self_load_compressor_named complearn_environment_load_compressor_named
#define self_get_nameable complearn_environment_get_nameable
#define self_register_nameable complearn_environment_register_nameable
#define self_load_modules complearn_environment_load_modules
#define self_load_builtins complearn_environment_load_builtins
#define self_register_compressor complearn_environment_register_compressor
#define self_compressor_count complearn_environment_compressor_count
#define self_compressor_list complearn_environment_compressor_list
#define self_build_home_filename complearn_environment_build_home_filename
#define self_apply_config_file complearn_environment_apply_config_file
#define self_lib_version complearn_environment_lib_version
#define self_make_home_config_file complearn_environment_make_home_config_file
#define self_get_home_config_filename complearn_environment_get_home_config_filename
#define self_get_config_filename_list complearn_environment_get_config_filename_list
#define self_apply_configs complearn_environment_apply_configs
#define self_show_properties complearn_environment_show_properties
#define self_find_name complearn_environment_find_name
#define self_register_property complearn_environment_register_property
#define self_check_homedir_subdir complearn_environment_check_homedir_subdir
#define self_glog_func complearn_environment_glog_func
#define self_handle_log_domain complearn_environment_handle_log_domain
#define self_standard_initialization complearn_environment_standard_initialization
#define self_adjust_parameter complearn_environment_adjust_parameter
#define self_apply_keyfile complearn_environment_apply_keyfile
#define self_build_module_dir_default complearn_environment_build_module_dir_default
#define self_set_verbose_mode complearn_environment_set_verbose_mode
#define self_convert_to_hex complearn_environment_convert_to_hex
GType
complearn_environment_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnEnvironmentClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_environment_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnEnvironment),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_environment_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "CompLearnEnvironment", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnEnvironment *)g_object_new(complearn_environment_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnEnvironment * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnEnvironment *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnEnvironment *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnEnvironment *)g_object_new_valist (complearn_environment_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:Environment::finalize"
	CompLearnEnvironment *self G_GNUC_UNUSED = COMPLEARN_ENVIRONMENT (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
complearn_environment_init (CompLearnEnvironment * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:Environment::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_ENVIRONMENT,CompLearnEnvironmentPrivate);
}
#undef __GOB_FUNCTION__
#line 74 "complearn-environment.gob"
static void 
complearn_environment_class_init (CompLearnEnvironmentClass * klass G_GNUC_UNUSED)
#line 219 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) klass;

	g_type_class_add_private(klass,sizeof(CompLearnEnvironmentPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("module_path" /* name */,
		 _("module_path") /* nick */,
		 _("directory where modules can be found") /* blurb */,
		 "/usr/lib/complearn/modules" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MODULE_PATH,
		param_spec);
	param_spec = g_param_spec_boolean
		("verbose" /* name */,
		 _("verbose") /* nick */,
		 _("print extra detailed information") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_VERBOSE,
		param_spec);
	param_spec = g_param_spec_int
		("nice_level" /* name */,
		 _("nice_level") /* nick */,
		 _("scheduling priority, higher is less CPU") /* blurb */,
		 -19 /* minimum */,
		 19 /* maximum */,
		 19 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_NICE_LEVEL,
		param_spec);
    }
 {
#line 74 "complearn-environment.gob"

    cltc = klass;
  
#line 269 "complearn-environment.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:Environment::set_property"
{
	CompLearnEnvironment *self G_GNUC_UNUSED;

	self = COMPLEARN_ENVIRONMENT (object);

	switch (property_id) {
	case PROP_MODULE_PATH:
		{
#line 96 "complearn-environment.gob"
{ char *old = self->_priv->module_path; self->_priv->module_path = g_value_dup_string (VAL); g_free (old); }
#line 290 "complearn-environment.c"
		}
		break;
	case PROP_VERBOSE:
		{
#line 104 "complearn-environment.gob"
self->_priv->verbose = g_value_get_boolean (VAL);
#line 297 "complearn-environment.c"
		}
		break;
	case PROP_NICE_LEVEL:
		{
#line 112 "complearn-environment.gob"
self->_priv->nice_level = g_value_get_int (VAL);
#line 304 "complearn-environment.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:Environment::get_property"
{
	CompLearnEnvironment *self G_GNUC_UNUSED;

	self = COMPLEARN_ENVIRONMENT (object);

	switch (property_id) {
	case PROP_MODULE_PATH:
		{
#line 96 "complearn-environment.gob"
g_value_set_string (VAL, self->_priv->module_path);
#line 335 "complearn-environment.c"
		}
		break;
	case PROP_VERBOSE:
		{
#line 104 "complearn-environment.gob"
g_value_set_boolean (VAL, self->_priv->verbose);
#line 342 "complearn-environment.c"
		}
		break;
	case PROP_NICE_LEVEL:
		{
#line 112 "complearn-environment.gob"
g_value_set_int (VAL, self->_priv->nice_level);
#line 349 "complearn-environment.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 77 "complearn-environment.gob"
GObject * 
complearn_environment_new (void)
#line 369 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::new"
{
#line 78 "complearn-environment.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    CompLearnEnvironment *self = COMPLEARN_ENVIRONMENT(ret);
    if (cl)
      g_error(_("Cannot make more than one environment, use complearn_init() to begin."));
    cl = self;
    self->_priv = calloc(1, sizeof(*self->_priv));
    g_datalist_init(&self->_priv->grouplist);
    g_datalist_init(&self->_priv->complist);
    self->_priv->propdeffile = NULL;
    self->_priv->backnames = g_hash_table_new(g_direct_hash, g_direct_equal);
    SET_DEFAULT_PROPS(PROJECTNAME, COMPLEARN_ENVIRONMENT_GET_CLASS, self);
    complearn_ncd_top();
    complearn_environment_standard_initialization();
    complearn_environment_apply_configs(TRUE, TRUE);
    return G_OBJECT (ret);
  }}
#line 391 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 96 "complearn-environment.gob"
gchar * 
complearn_environment_get_module_path (CompLearnEnvironment * self)
#line 397 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_module_path"
{
#line 96 "complearn-environment.gob"
		gchar* val; g_object_get (G_OBJECT (self), "module_path", &val, NULL); return val;
}}
#line 404 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 96 "complearn-environment.gob"
void 
complearn_environment_set_module_path (CompLearnEnvironment * self, gchar * val)
#line 410 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::set_module_path"
{
#line 96 "complearn-environment.gob"
		g_object_set (G_OBJECT (self), "module_path", val, NULL);
}}
#line 417 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 104 "complearn-environment.gob"
gboolean 
complearn_environment_get_verbose (CompLearnEnvironment * self)
#line 423 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_verbose"
{
#line 104 "complearn-environment.gob"
		gboolean val; g_object_get (G_OBJECT (self), "verbose", &val, NULL); return val;
}}
#line 430 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 104 "complearn-environment.gob"
void 
complearn_environment_set_verbose (CompLearnEnvironment * self, gboolean val)
#line 436 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::set_verbose"
{
#line 104 "complearn-environment.gob"
		g_object_set (G_OBJECT (self), "verbose", val, NULL);
}}
#line 443 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 112 "complearn-environment.gob"
gint 
complearn_environment_get_nice_level (CompLearnEnvironment * self)
#line 449 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_nice_level"
{
#line 112 "complearn-environment.gob"
		gint val; g_object_get (G_OBJECT (self), "nice_level", &val, NULL); return val;
}}
#line 456 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 112 "complearn-environment.gob"
void 
complearn_environment_set_nice_level (CompLearnEnvironment * self, gint val)
#line 462 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::set_nice_level"
{
#line 112 "complearn-environment.gob"
		g_object_set (G_OBJECT (self), "nice_level", val, NULL);
}}
#line 469 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 121 "complearn-environment.gob"
CompLearnEnvironment * 
complearn_environment_top (void)
#line 475 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::top"
{
#line 122 "complearn-environment.gob"
	
    if (cl == NULL)
      complearn_environment_new();
    g_assert(cl != NULL);
    return(cl);
  }}
#line 486 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 128 "complearn-environment.gob"
char * 
complearn_environment_version (void)
#line 492 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::version"
{
#line 128 "complearn-environment.gob"
	
    return g_strdup(VERSION);
  }}
#line 500 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 131 "complearn-environment.gob"
CompLearnRealCompressor * 
complearn_environment_load_compressor_named (const char * name)
#line 506 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::load_compressor_named"
{
#line 132 "complearn-environment.gob"
	
    CompLearnEnvironment *clb = complearn_environment_top();
    void *result = g_datalist_get_data(&clb->_priv->complist, name);
    return result ? COMPLEARN_REAL_COMPRESSOR(result) : NULL;
  }}
#line 516 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 137 "complearn-environment.gob"
GObject * 
complearn_environment_get_nameable (const char * name)
#line 522 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_nameable"
{
#line 138 "complearn-environment.gob"
	
    CompLearnEnvironment *clb = complearn_environment_top();
    void *result = g_datalist_get_data(&clb->_priv->grouplist, name);
    return result ? G_OBJECT(result) : NULL;
  }}
#line 532 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 143 "complearn-environment.gob"
void 
complearn_environment_register_nameable (const char * name, GObject * val)
#line 538 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::register_nameable"
{
#line 143 "complearn-environment.gob"
	
    CompLearnEnvironment *clb = complearn_environment_top();
    if (complearn_environment_get_nameable(name))
      g_error(_("Cannot register more than one object under name %s"), name);
    char *dupname = g_strdup(name);
    g_datalist_set_data(&clb->_priv->grouplist, dupname, val);
    g_hash_table_insert(clb->_priv->backnames, val, dupname);
    if (IS_COMPLEARN_REAL_COMPRESSOR(val))
        complearn_environment_register_compressor(
       (COMPLEARN_REAL_COMPRESSOR(val)));
  }}
#line 554 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 154 "complearn-environment.gob"
static void 
complearn_environment_load_modules (void)
#line 560 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::load_modules"
{
#line 154 "complearn-environment.gob"
	
    GModule *gm;
    GError *err = NULL;
    GSList *result = NULL;
    char *dirname = complearn_environment_get_module_path(complearn_environment_top());
    g_notice(_("Trying to read modules directory %s"), dirname);
    GDir *d = g_dir_open(dirname, 0,&err);
    if (err)
      return;
    const char *n;
    while (n = g_dir_read_name(d)) {
      char *cur = g_build_filename(dirname, n, NULL);
      g_notice(_("Trying to load module %s"), cur);
      if (g_file_test(cur, G_FILE_TEST_IS_REGULAR)) {
        gm = g_module_open(cur, G_MODULE_BIND_LOCAL | G_MODULE_BIND_LAZY);
        if (gm == NULL)
          g_error(_("Error loading module %s"), n);
        g_notice(_("Loaded module %s successfully"), cur);
      }
      g_free(cur);
    }
  g_dir_close(d);
  }}
#line 588 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 177 "complearn-environment.gob"
static void 
complearn_environment_load_builtins (void)
#line 594 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::load_builtins"
{
#line 177 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  complearn_environment_register_compressor(COMPLEARN_REAL_COMPRESSOR(complearn_vcblocksort_new()));
  complearn_environment_register_compressor(COMPLEARN_REAL_COMPRESSOR(complearn_rcbzip_new()));
  complearn_environment_register_compressor(COMPLEARN_REAL_COMPRESSOR(complearn_rcbzlib_new()));
  complearn_environment_register_compressor(COMPLEARN_REAL_COMPRESSOR(complearn_rcgzip_new()));
  complearn_environment_register_compressor(COMPLEARN_REAL_COMPRESSOR(complearn_rczlib_new()));
  }}
#line 607 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 185 "complearn-environment.gob"
void 
complearn_environment_register_compressor (CompLearnRealCompressor * rc)
#line 613 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::register_compressor"
{
#line 185 "complearn-environment.gob"
	
  GString *name = real_compressor_name(rc);
  if (g_datalist_get_data(&cl->_priv->complist, name->str)) {
    goto donenow;
  }
  if (!real_compressor_is_operational(rc)) {
    g_notice(_("Compressor %s is not operational."), name->str);
    goto donenow;
  }
  g_datalist_set_data(&cl->_priv->complist, name->str, rc);
  if (complearn_environment_get_nameable( name->str ) == NULL)
    complearn_environment_register_nameable(name->str, G_OBJECT(rc));
  donenow:
    g_string_free(name, TRUE);
  }}
#line 633 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 201 "complearn-environment.gob"
int 
complearn_environment_compressor_count (void)
#line 639 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::compressor_count"
{
#line 202 "complearn-environment.gob"
	
    CompLearnEnvironment *clb = complearn_environment_top();
  gint32 acc = 0;
  g_datalist_foreach(&clb->_priv->complist, foreachIncr, &acc);
  return acc;
}}
#line 650 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 208 "complearn-environment.gob"
char ** 
complearn_environment_compressor_list (void)
#line 656 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::compressor_list"
{
#line 209 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  int cc;
  int i;
  static char **compnames, **dc;
  cc = complearn_environment_compressor_count();
  compnames = calloc(sizeof(gpointer), cc+1);
  dc = compnames;
  g_datalist_foreach(&clb->_priv->complist, foreachNamer, &dc);
  for (i = 0; i < cc; i += 1) {
    g_assert(compnames[i] != NULL);
  }
  qsort(compnames, cc, sizeof(gpointer), alphacomp);
  return compnames;
}}
#line 676 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 225 "complearn-environment.gob"
static char * 
complearn_environment_build_home_filename (const char * inp)
#line 682 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::build_home_filename"
{
#line 225 "complearn-environment.gob"
	
  return g_build_filename(g_get_home_dir(), "." PROJECTNAME, inp, NULL);
}}
#line 690 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 228 "complearn-environment.gob"
static void 
complearn_environment_apply_config_file (const char * fname)
#line 696 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::apply_config_file"
{
#line 228 "complearn-environment.gob"
	
  GError *err = NULL;
  GKeyFile *k = g_key_file_new();
  int i;
  gchar **groups = NULL;
  if (!g_key_file_load_from_file(k, fname, 0, &err))
    goto donenow;
  g_notice(_("Reading config file %s."), fname);
  int len;
  groups = g_key_file_get_groups(k, &len);
  for (i = 0; groups[i]; i += 1) {
    if (strcmp(groups[i], PROJECTNAME) == 0)
      continue;
    GObject *obj = complearn_environment_get_nameable( groups[i]);
    if (obj == NULL)
      g_warning(_("Cannot find group %s"), groups[i]);
    else
      complearn_environment_apply_keyfile(k, obj);
  }
  donenow:
    g_key_file_free(k);
    g_strfreev(groups);
}}
#line 724 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 252 "complearn-environment.gob"
GString * 
complearn_environment_lib_version (void)
#line 730 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::lib_version"
{
#line 252 "complearn-environment.gob"
	
    return g_string_new(VERSION);
}}
#line 738 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 255 "complearn-environment.gob"
void 
complearn_environment_make_home_config_file (void)
#line 744 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::make_home_config_file"
{
#line 256 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  GSList *lines = NULL, *it;
  FILE *fp = fopen(complearn_environment_get_home_config_filename(), "w");
  if (fp == NULL) {
    g_warning(_("Cannot open file %s for writing"), complearn_environment_get_home_config_filename());
  }
  lines = clb->_priv->propdeffile;
  for (it = lines; it; it = g_slist_next(it)) {
    fprintf(fp, "%s", ((GString *) (it->data))->str);
  }
  fclose(fp);
}}
#line 762 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 269 "complearn-environment.gob"
char * 
complearn_environment_get_home_config_filename (void)
#line 768 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_home_config_filename"
{
#line 270 "complearn-environment.gob"
	
  return g_build_filename(g_get_home_dir(), "." PROJECTNAME,CONFIGNAME, NULL);
}}
#line 776 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 273 "complearn-environment.gob"
char ** 
complearn_environment_get_config_filename_list (void)
#line 782 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::get_config_filename_list"
{
#line 274 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  const gchar * const *sysdirs;
  const gchar * const *cur;
  sysdirs = g_get_system_data_dirs();
  GSList *names = NULL, *it;
  for (cur = sysdirs; *cur; cur += 1) {
    names=g_slist_append(names, g_build_filename(*cur, PROJECTNAME,CONFIGNAME, NULL));
  }
  names=g_slist_append(names, complearn_environment_get_home_config_filename());
  char **result = calloc(sizeof(*result), g_slist_length(names)+1);
  int i = 0;
  for (it = names; it; it = g_slist_next(it))
    result[i++] = it->data;
  g_slist_free(names);
  return result;
}}
#line 804 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 292 "complearn-environment.gob"
void 
complearn_environment_apply_configs (gboolean env_part, gboolean other_part)
#line 810 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::apply_configs"
{
#line 293 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  const gchar * const *sysdirs;
  char **filesToRead = complearn_environment_get_config_filename_list();
  char **filename;
  GError *err;
  if (env_part) {
    for (filename = filesToRead; *filename; filename++) {
      err = NULL;
      GKeyFile *kf = g_key_file_new();
      if (g_key_file_load_from_file(kf, *filename, 0, &err))
        complearn_environment_apply_keyfile(kf, G_OBJECT(clb));
      g_key_file_free(kf);
    }
  }
  if (other_part) {
    for (filename = filesToRead; *filename; filename++) {
      complearn_environment_apply_config_file(*filename);
    }
  }
}}
#line 836 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 315 "complearn-environment.gob"
void 
complearn_environment_show_properties (void)
#line 842 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::show_properties"
{
#line 316 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  //printf("average_matrix: %d\n", complearn_environment_get_average_matrix(clb));
  printf("nice_level:     %d\n", complearn_environment_get_nice_level(clb));
//  printf("compressor:     %s\n", complearn_environment_get_compressor(clb));
}}
#line 853 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 322 "complearn-environment.gob"
char * 
complearn_environment_find_name (GObject * obj)
#line 859 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::find_name"
{
#line 323 "complearn-environment.gob"
	
  CompLearnEnvironment *clb = complearn_environment_top();
  return g_hash_table_lookup(clb->_priv->backnames, obj);
}}
#line 868 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 327 "complearn-environment.gob"
void 
complearn_environment_register_property (GObject * obj, GParamSpec * gps, GValue * v)
#line 874 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::register_property"
{
#line 328 "complearn-environment.gob"
	
  static char *lastProp = NULL;
  char *kname = gps->name;
  char *vstr = NULL;
  char buf[128];
  CompLearnEnvironment *clb = complearn_environment_top();
  char *name = complearn_environment_find_name( obj);
  g_assert(name != NULL);
  if (lastProp != name) {
    GString *gbuf = g_string_new(""); g_string_sprintf(gbuf, "\n# [%s]\n\n", name);
    clb->_priv->propdeffile = g_slist_append(clb->_priv->propdeffile, gbuf);
    lastProp = name;
  }
  switch(gps->value_type) {
    case G_TYPE_BOOLEAN:
      vstr = g_strdup(g_value_get_boolean(v) ? "yes" : "no");
      break;
    case G_TYPE_DOUBLE:
      sprintf(buf, "%f", g_value_get_double(v));
      vstr = g_strdup(buf);
      break;
    case G_TYPE_STRING:
      vstr = g_strdup(g_value_get_string(v));
      break;
    case G_TYPE_INT:
      sprintf(buf, "%d", g_value_get_int(v));
      vstr = g_strdup(buf);
      break;
    default:
      g_error(_("Type %s unknown"), G_PARAM_SPEC_TYPE_NAME(gps));
  }
  g_assert(vstr != NULL);
  GString *gbuf = g_string_new("");
  g_string_sprintf(gbuf, "# %s\n#    %s=%s\n", g_param_spec_get_blurb(gps), kname, vstr);
  clb->_priv->propdeffile = g_slist_append(clb->_priv->propdeffile, gbuf);
  g_free(vstr);
}}
#line 916 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 365 "complearn-environment.gob"
gboolean 
complearn_environment_check_homedir_subdir (void)
#line 922 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::check_homedir_subdir"
{
#line 366 "complearn-environment.gob"
	
  GError *err = NULL;
  CompLearnEnvironment *clb = complearn_environment_top();
  char *wanted = complearn_environment_build_home_filename(".");
  GDir *d = g_dir_open(wanted,0,&err);
  free(wanted);
  if (d) {
    g_dir_close(d);
    return TRUE;
  }
  return FALSE;
}}
#line 939 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 378 "complearn-environment.gob"
void 
complearn_environment_glog_func (const gchar * log_domain, GLogLevelFlags log_level, const gchar * message, gpointer user_data)
#line 945 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::glog_func"
{
#line 380 "complearn-environment.gob"
	
  if (log_level == G_LOG_LEVEL_NOTICE) {
    if (complearn_environment_get_verbose(complearn_environment_top()))
      fprintf(stderr, "D:%s:%s\n", log_domain, message);
  }
  else {
    g_log_default_handler(log_domain, log_level, message, user_data);
  }
}}
#line 959 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 390 "complearn-environment.gob"
void 
complearn_environment_handle_log_domain (const gchar * log_domain)
#line 965 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::handle_log_domain"
{
#line 390 "complearn-environment.gob"
	
  g_log_set_handler(log_domain, G_LOG_LEVEL_NOTICE, complearn_environment_glog_func, NULL);
}}
#line 973 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 394 "complearn-environment.gob"
void 
complearn_environment_standard_initialization (void)
#line 979 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::standard_initialization"
{
#line 395 "complearn-environment.gob"
	
  int retval;
  bindtextdomain (PACKAGE, "/usr/share/locale");
  g_log_set_default_handler(complearn_environment_glog_func, NULL);
  complearn_environment_apply_configs(TRUE, FALSE);
  complearn_environment_load_builtins();
  complearn_environment_load_modules();
  complearn_ncd_top();
  CompLearnEnvironment *clb = complearn_environment_top();
  if (!complearn_environment_check_homedir_subdir()) {
    char *wanted = complearn_environment_build_home_filename(".");
    wanted[strlen(wanted)-2] = '\0';
    g_mkdir(wanted, 0700);
    g_free(wanted);
  }
  if (!g_file_test(complearn_environment_get_home_config_filename(), G_FILE_TEST_EXISTS))
    complearn_environment_make_home_config_file();
#if HAVE_UNISTD_H
   errno = 0;
   retval = nice(clb->_priv->nice_level);
  if (errno != 0)
    g_warning(_("Warning: cannot set nice priority to level %d"), clb->_priv->nice_level);
   g_notice(_("Set nice priority level to %d"), clb->_priv->nice_level);
#endif
}}
#line 1009 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 420 "complearn-environment.gob"
void 
complearn_environment_adjust_parameter (GObject * obj, const char * kname, const char * val)
#line 1015 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::adjust_parameter"
{
#line 423 "complearn-environment.gob"
	
    GValue gval = {0,};
    GObjectClass *goc = G_OBJECT_GET_CLASS(obj);
    GParamSpec *gps;
    gps = g_object_class_find_property(goc, kname);
    if (gps) {
      switch(gps->value_type) {
        case G_TYPE_BOOLEAN:
          g_value_init(&gval, G_TYPE_BOOLEAN);
          gboolean v = (val[0] == 'y' || val[0] == 'Y' || val[0] == '1');
          g_value_set_boolean(&gval, v);
          break;
        case G_TYPE_DOUBLE:
          g_value_init(&gval, G_TYPE_DOUBLE);
          g_value_set_double(&gval, atof(val));
          break;
        case G_TYPE_STRING:
          g_value_init(&gval, G_TYPE_STRING);
          g_value_set_string(&gval, val);
          break;
        case G_TYPE_INT:
          g_value_init(&gval, G_TYPE_INT);
          g_value_set_int(&gval, atoi(val));
          break;
        default:
          g_error(_("Type %s unknown"), G_PARAM_SPEC_TYPE_NAME(gps));
      }
    }
    else
      g_error(_("No property named %s in object."), kname);
    g_object_set_property(obj, kname, &gval);
  }}
#line 1052 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 455 "complearn-environment.gob"
void 
complearn_environment_apply_keyfile (GKeyFile * kf, GObject * obj)
#line 1058 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::apply_keyfile"
{
#line 456 "complearn-environment.gob"
	
    CompLearnEnvironment *clb = complearn_environment_top();
    char *name = complearn_environment_find_name( obj);
    if (name == NULL)
      g_error(_("No name for object at %p"), obj);
    if (kf == NULL)
      g_error(_("NULL keyfile for %s."), name);
    if (obj == NULL)
      g_error(_("No object at %s."), name);
    GError *err = NULL;
    char **kname;
    kname = g_key_file_get_keys(kf, name, NULL, &err);
    if (kname == NULL || err != NULL) // No keys
      return;
    int i;
    GObjectClass *goc = G_OBJECT_GET_CLASS(obj);
    for (i = 0; kname[i]; i += 1) {
      char *val;
      err = NULL;
      val = g_key_file_get_string(kf, name, kname[i], &err);
      complearn_environment_adjust_parameter(obj, kname[i], val);
    }
    g_strfreev(kname);
  }}
#line 1087 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 480 "complearn-environment.gob"
static char * 
complearn_environment_build_module_dir_default (void)
#line 1093 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::build_module_dir_default"
{
#line 480 "complearn-environment.gob"
	
    return "/usr/lib/complearn/modules";
  }}
#line 1101 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 483 "complearn-environment.gob"
void 
complearn_environment_set_verbose_mode (void)
#line 1107 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::set_verbose_mode"
{
#line 483 "complearn-environment.gob"
	
    complearn_environment_set_verbose(complearn_environment_top(), TRUE);
  }}
#line 1115 "complearn-environment.c"
#undef __GOB_FUNCTION__

#line 486 "complearn-environment.gob"
GString * 
complearn_environment_convert_to_hex (GString * inp)
#line 1121 "complearn-environment.c"
{
#define __GOB_FUNCTION__ "CompLearn:Environment::convert_to_hex"
{
#line 486 "complearn-environment.gob"
	
  char *hbuf;
  hbuf = calloc((inp->len+10)*2, 1);
  int i;
  for (i = 0; i < inp->len; i += 1)
    sprintf(hbuf+i*2, "%02x", ((unsigned char *) (inp->str))[i]);
  GString *result = g_string_new(hbuf);
  free(hbuf);
  return result;
  }}
#line 1136 "complearn-environment.c"
#undef __GOB_FUNCTION__
