#if   !defined(__SYNCHRONIZED_HPP)
#define  __SYNCHRONIZED_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if !defined IN_COMMON_HPP
   #error Synchronized.hpp is included by Common.hpp only.
#endif

#if !defined(__SEMAPHOREEXCEPTION_HPP)
#include <SemaphoreException.hpp>
#endif

namespace corelinux
{
  DECLARE_CLASS( Synchronized );

  /**
     Synchronized is a mixin which allows class objects
     to enable monitor functionality
  */

  class Synchronized
  {
  protected:
    
    DECLARE_CLASS( Guard );

    /**
       Guard is the automatic instance that insures
       a lock is not held beyond the scope where it
       was instantiated.
    */
      
    class Guard
    {

    public:

      /// Default constructor

      Guard( GuardCref );


      /// Destructor

      ~Guard( void );


      //
      // Mutator
      //

      /// Releases before destruction

      void  release( void );

    protected:

      friend   class Synchronized;

      /// Called by Synchronized object

      Guard( SynchronizedPtr );

      /// Default constructor never called

      Guard( void );

      /// Assignment operator never called

      GuardRef operator=( GuardCref );

    private:

      /// The object being guarded

      mutable  SynchronizedPtr   theSynchronized;
    };

  public:

    //
    // Constructors and destructor
    //

    /// Default constructor

    Synchronized( void );

    /// Copy constructor

    Synchronized( SynchronizedCref );

    /// Virtual Destructor

    virtual           ~Synchronized( void );

    //
    // Operator overloads
    //

    /// Assignment operator

    SynchronizedRef   operator=( SynchronizedCref );

    /// Equality operator

    bool  operator==( SynchronizedCref ) const;

  protected:

    //
    // Mutators
    //

    /**
       Access returns a instance of Guard which is block
       scoped to the caller.
       @return Guard the blocking instance
    */

    Guard    access( void ) const throw(SemaphoreException) ;


  };

#define  GUARD \
   Guard    aGuardedLock( this->access() )
}


#endif // if   !defined(__SYNCHRONIZED_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.4 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/

