/* 
 * $Id: ctkoptionmenu.h,v 1.7 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTK_OPTION_MENU_H__
# define __CTK_OPTION_MENU_H__ 

typedef struct CtkOptionMenu_S
{
      CtkButton button;
      
      gboolean open;
      gboolean wasDragged;
      gboolean doClose;
      gboolean clicked;

      /* Signal handler ids */
      gint lost_focus;
      gint select_row;
      gint key_press;
      gint button_press;

      CtkWidget* menu;
      CtkWidget* window;
      CtkWidget* scroll;
} CtkOptionMenu;

void ctk_option_menu_init(CtkOptionMenu *optionmenu);
CtkWidget *ctk_option_menu_new(void);
void ctk_option_menu_set_menu(CtkOptionMenu *option_menu, CtkWidget *menu);
void ctk_option_menu_set_history(CtkOptionMenu *option_menu, guint index);
gint ctk_option_menu_get_history(CtkOptionMenu* option_menu);
void ctk_option_menu_remove_menu(CtkOptionMenu *option_menu);
CtkWidget *ctk_option_menu_get_menu(CtkOptionMenu *option_menu);

#define CTK_OPTION_MENU(obj)	CTK_CHECK_CAST((obj),CtkOptionMenu,CtkTypeOptionMenu)

#endif
