#ifndef DEBUG_H
#define DEBUG_H

#ifndef CWDEBUG

#define AllocTag1(p)
#define AllocTag2(p, desc)
#define AllocTag_dynamic_description(p, x)
#define AllocTag(p, x)
#define Debug(x)
#define Dout(a, b)
#define DoutFatal(a, b) LibcwDoutFatal(::std, , a, b)
#define ForAllDebugChannels(STATEMENT)
#define ForAllDebugObjects(STATEMENT)
#define LibcwDebug(dc_namespace, x)
#define LibcwDout(a, b, c, d)
#define LibcwDoutFatal(a, b, c, d) do { ::std::cerr << d << ::std::endl; ::std::exit(254); } while(1)
#define NEW(x) new x
#define CWDEBUG_ALLOC 0
#define CWDEBUG_MAGIC 0
#define CWDEBUG_LOCATION 0
#define CWDEBUG_LIBBFD 0
#define CWDEBUG_DEBUG 0
#define CWDEBUG_DEBUGOUTPUT 0
#define CWDEBUG_DEBUGM 0
#define CWDEBUG_DEBUGT 0
#define CWDEBUG_MARKER 0

#else // CWDEBUG

#ifndef DEBUGCHANNELS
// This must be defined before <libcwd/debug.h> is included and must be the
// name of the namespace containing your `dc' (Debug Channels) namespace
// (see below).  You can use any namespace(s) you like, except existing
// namespaces (like ::, ::std and ::libcwd).
#define DEBUGCHANNELS ::myproject::debug::channels
#endif
#include <libcwd/debug.h>

namespace myproject {
  namespace debug {

    void init(void);		// Initialize debugging code from main().
    void init_thread(void);	// Initialize debugging code from new threads.

    namespace channels {	//  >---> This namespace must match DEBUGCHANNELS

      namespace dc {
	using namespace ::libcwd::channels::dc;
	using ::libcwd::channel_ct;

	// Add the declaration of new debug channels here
	// and add their definition in a custom debug.cc file.
	extern channel_ct custom;

      } // namespace dc

    } // namespace DEBUGCHANNELS
  }
}

#endif // CWDEBUG

#endif // DEBUG_H
