import java.io.*;
import java.lang.*;
import java.util.*;
import com.tildemh.debbug.*;

/**
 * Testing Package listings.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ListingTest.java,v 1.6 2003/03/31 15:49:50 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ListingTest{

	public static void main(String[] args) throws Exception{

		BTS bts;
		bts = BTS.getInstance();

		com.tildemh.debbug.Listing pkg = null;
		File f = new File(args[0]);
		if (f.exists()){
			// load from file
		
			StringBuffer htmlPage = new StringBuffer();
			FileReader reader = new FileReader(args[0]);
			int ch =0;
			while ((ch = reader.read()) != -1){
				htmlPage.append((char)ch);
			}
		
			pkg = WWWListingParser.makeListing(htmlPage.toString());
			pkg.setUpdated();
			(Cache.getInstance()).store(pkg);
		}else{
			// load from web
			ListingType type = null;
			if (args[0].equals("source")){
				type = ListingType.SOURCE;
			}else if (args[0].equals("binary")){
				type = ListingType.BINARY;
			}else if (args[0].equals("maint")){
				type = ListingType.MAINT;
			}else if (args[0].equals("submitter")){
				type = ListingType.SUBMITTER;
			}
			pkg = bts.getListing( type, args[1], true);
		}

		System.out.println("Package: "+ pkg.getName());
		
		LinkedList bugs = pkg.getBugNumbers();

		while (bugs.size() > 0){
			Bug bug;
			Integer num = (Integer) bugs.removeFirst();
			
		//	System.out.println("Getting bug #"+bug.getNumber());
			bug = bts.getBug(num.intValue(), true, true);
				
//			System.out.println("---------------------------------------");
//			System.out.println( bug.getNumber() );
//			System.out.println( bug.getTitle() );
//			System.out.println( bug.getSeverity() );
			System.out.println( bug.getCreated().toString() );
			System.out.println( "Forwarded: "+bug.getForwarded() );
			System.out.println( "Done: "+bug.getDone() );
			LinkedList tags = bug.getTags();
			System.out.print("Tags: ");
			while (tags.size()>0){
				Tag tag = (Tag) tags.removeFirst();
				System.out.println( tag.toString()+"  ");
			}
			System.out.println("");
//
		}
	}

}
