/* module-guesser.c generated by valac, the Vala compiler
 * generated from module-guesser.vala, do not modify */

/*
 * Desktop Agnostic Module guesser function.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <libdesktop-agnostic/vfs.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



GType guess_module (DesktopAgnosticModuleLoader* loader, const char* library_prefix);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



GType guess_module (DesktopAgnosticModuleLoader* loader, const char* library_prefix) {
	GType result;
	GError * _inner_error_;
	char** _tmp1_;
	gint paths_size;
	gint paths_length1;
	gint _tmp0_;
	char** paths;
	char* module_glob_suffix;
	GType _result_;
	g_return_val_if_fail (loader != NULL, 0UL);
	g_return_val_if_fail (library_prefix != NULL, 0UL);
	_inner_error_ = NULL;
	paths = (_tmp1_ = desktop_agnostic_module_loader_get_search_paths (&_tmp0_), paths_length1 = _tmp0_, paths_size = paths_length1, _tmp1_);
	module_glob_suffix = g_strdup_printf ("%s*", library_prefix);
	_result_ = G_TYPE_INVALID;
	{
		char** path_prefix_collection;
		int path_prefix_collection_length1;
		int path_prefix_it;
		path_prefix_collection = paths;
		path_prefix_collection_length1 = paths_length1;
		for (path_prefix_it = 0; path_prefix_it < paths_length1; path_prefix_it = path_prefix_it + 1) {
			const char* path_prefix;
			path_prefix = path_prefix_collection[path_prefix_it];
			{
				gboolean _tmp2_ = FALSE;
				char* module_glob;
				if (path_prefix == NULL) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = !g_file_test (path_prefix, G_FILE_TEST_IS_DIR);
				}
				if (_tmp2_) {
					continue;
				}
				module_glob = g_build_filename (path_prefix, module_glob_suffix, NULL);
				{
					DesktopAgnosticVFSGlob* found_modules;
					gint modules_paths_size;
					gint modules_paths_length1;
					char** modules_paths;
					DesktopAgnosticVFSGlob* _tmp3_;
					DesktopAgnosticVFSGlob* _tmp4_;
					char** _tmp6_;
					gint _tmp5_;
					found_modules = NULL;
					modules_paths = (modules_paths_length1 = 0, NULL);
					_tmp3_ = desktop_agnostic_vfs_glob_execute (module_glob, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (found_modules);
						if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
							goto __catch0_desktop_agnostic_vfs_glob_error;
						}
						_g_object_unref0 (found_modules);
						_g_free0 (module_glob);
						paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (module_glob_suffix);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0UL;
					}
					found_modules = (_tmp4_ = _tmp3_, _g_object_unref0 (found_modules), _tmp4_);
					modules_paths = (_tmp6_ = desktop_agnostic_vfs_glob_get_paths (found_modules, &_tmp5_), modules_paths_length1 = _tmp5_, modules_paths_size = modules_paths_length1, _tmp6_);
					{
						char** module_collection;
						int module_collection_length1;
						int module_it;
						module_collection = modules_paths;
						module_collection_length1 = modules_paths_length1;
						for (module_it = 0; module_it < modules_paths_length1; module_it = module_it + 1) {
							const char* module;
							module = module_collection[module_it];
							{
								_result_ = desktop_agnostic_module_loader_load_from_path (loader, path_prefix, module);
								if (_result_ != G_TYPE_INVALID) {
									break;
								}
							}
						}
					}
					_g_object_unref0 (found_modules);
				}
				goto __finally0;
				__catch0_desktop_agnostic_vfs_glob_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					{
						if (!g_error_matches (err, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOMATCH)) {
							g_warning ("module-guesser.vala:65: Glob-related eror: %s", err->message);
						}
						_g_error_free0 (err);
					}
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_free0 (module_glob);
					paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (module_glob_suffix);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0UL;
				}
				if (_result_ != G_TYPE_INVALID) {
					_g_free0 (module_glob);
					break;
				}
				_g_free0 (module_glob);
			}
		}
	}
	result = _result_;
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (module_glob_suffix);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




