/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12077 $ of $
 *
 * $Id:$
 *
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "dessertAppParamsTable.h"
#include "dessertAppParamsTable_enums.h"
#include "../dessert_internal.h"


/** @defgroup data_set data_set: Routines to set data
 *
 * These routines are used to set the value for individual objects. The
 * row context is passed, along with the new value.
 * 
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table dessertAppParamsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * DESSERT-MIB::dessertAppParamsTable is subid 9 of dessertObjects.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9, length: 13
 */
    /*
     * NOTE: if you update this chart, please update the versions in
     *       local/mib2c-conf.d/parent-set.m2i
     *       agent/mibgroup/helpers/baby_steps.c
     * while you're at it.
     */
    /*
     ***********************************************************************
     * Baby Steps Flow Chart (2004.06.05)                                  *
     *                                                                     *
     * +--------------+    +================+    U = unconditional path    *
     * |optional state|    ||required state||    S = path for success      *
     * +--------------+    +================+    E = path for error        *
     ***********************************************************************
     *
     *                        +--------------+
     *                        |     pre      |
     *                        |   request    |
     *                        +--------------+
     *                               | U
     *                        +==============+
     *       +----------------||  object    ||
     *       |              E ||  lookup    ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |              E ||   check    ||
     *       |<---------------||   values   ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |       +<-------||   undo     ||
     *       |       |      E ||   setup    ||
     *       |       |        +==============+
     *       |       |               | S
     *       |       |        +==============+
     *       |       |        ||    set     ||-------------------------->+
     *       |       |        ||   value    || E                         |
     *       |       |        +==============+                           |
     *       |       |               | S                                 |
     *       |       |        +--------------+                           |
     *       |       |        |    check     |-------------------------->|
     *       |       |        |  consistency | E                         |
     *       |       |        +--------------+                           |
     *       |       |               | S                                 |
     *       |       |        +==============+         +==============+  |
     *       |       |        ||   commit   ||-------->||     undo   ||  |
     *       |       |        ||            || E       ||    commit  ||  |
     *       |       |        +==============+         +==============+  |
     *       |       |               | S                     U |<--------+
     *       |       |        +--------------+         +==============+
     *       |       |        | irreversible |         ||    undo    ||
     *       |       |        |    commit    |         ||     set    ||
     *       |       |        +--------------+         +==============+
     *       |       |               | U                     U |
     *       |       +-------------->|<------------------------+
     *       |                +==============+
     *       |                ||   undo     ||
     *       |                ||  cleanup   ||
     *       |                +==============+
     *       +---------------------->| U
     *                        +--------------+
     *                        |    post      |
     *                        |   request    |
     *                        +--------------+
     *
     */

/**
 * Setup up context with information needed to undo a set request.
 *
 * This function will be called before the individual node undo setup
 * functions are called. If you need to do any undo setup that is not
 * related to a specific column, you can do it here.
 *
 * Note that the undo context has been allocated with
 * dessertAppParamsTable_allocate_data(), but may need extra
 * initialization similar to what you may have done in
 * dessertAppParamsTable_rowreq_ctx_init().
 * Note that an individual node's undo_setup function will only be called
 * if that node is being set to a new value.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in the node's undo_setup
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
dessertAppParamsTable_undo_setup(dessertAppParamsTable_rowreq_ctx *
                                 rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_undo_setup", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> Setup dessertAppParamsTable undo.
     * set up dessertAppParamsTable undo information, in preparation for a set.
     * Undo storage is in (* appParamsOctetString_val_ptr_ptr )*
     */

    return rc;
}                               /* dessertAppParamsTable_undo_setup */

/**
 * Undo a set request.
 *
 * This function will be called before the individual node undo
 * functions are called. If you need to do any undo that is not
 * related to a specific column, you can do it here.
 *
 * Note that an individual node's undo function will only be called
 * if that node is being set to a new value.
 *
 * If there is anything  specific to a particular column (e.g. releasing
 * memory for a string), you should do that setup in the node's undo
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
dessertAppParamsTable_undo(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_undo",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> dessertAppParamsTable undo.
     * dessertAppParamsTable undo information, in response to a failed set.
     * Undo storage is in (* appParamsOctetString_val_ptr_ptr )*
     */

    return rc;
}                               /* dessertAppParamsTable_undo_setup */

/**
 * Cleanup up context undo information.
 *
 * This function will be called after set/commit processing. If you
 * allocated any resources in undo_setup, this is the place to release
 * those resources.
 *
 * This function is called regardless of the success or failure of the set
 * request. If you need to perform different steps for cleanup depending
 * on success or failure, you can add a flag to the rowreq_ctx.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
dessertAppParamsTable_undo_cleanup(dessertAppParamsTable_rowreq_ctx *
                                   rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_undo_cleanup", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:452:M: |-> Cleanup dessertAppParamsTable undo.
     * Undo storage is in (* appParamsOctetString_val_ptr_ptr )*
     */

    return rc;
}                               /* dessertAppParamsTable_undo_cleanup */

/**
 * commit new values.
 *
 * At this point, you should have done everything you can to ensure that
 * this commit will not fail.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * dessertAppParamsTable_oids.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param dessertAppParamsTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
dessertAppParamsTable_commit(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;
    int             save_flags;
    dessert_agentx_appparams_t *appparam;
    dessert_agentx_appparamscb_set_t *set;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_commit", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    set = _dessert_agentx_appparams_getsettercbforindex(rowreq_ctx->tbl_idx.appParamsIndex);

	if (set == NULL) {
		snmp_log(
				LOG_ERR,
				"dessertAppParamsTable commit failed, no setter for index %ld!\n",
				rowreq_ctx->tbl_idx.appParamsIndex);
		return MFD_ERROR;
	}

	/*
     * save flags, then clear until we actually do something
     */
    save_flags = rowreq_ctx->column_set_flags;
    rowreq_ctx->column_set_flags = 0;

    appparam = malloc(sizeof(dessert_agentx_appparams_t));

    appparam->index = rowreq_ctx->tbl_idx.appParamsIndex;
    appparam->value_type = rowreq_ctx->data.appParamsValueType;

    dessert_debug("commit\n"
			"\n\t\trowreq_ctx->tbl_idx                  \t[%u]"
			"\n\t\trowreq_ctx->data.appParamsValueType  \t[%u]"
			"\n\t\trowreq_ctx->data.appParamsTruthValue \t[%u]"
			"\n\t\trowreq_ctx->data.appParamsInteger32  \t[%d]"
			"\n\t\trowreq_ctx->data.appParamsUnsigned32 \t[%u]"
    		"\n\t\trowreq_ctx->data.appParamsOctetString_len \t[%u]"

			"\n",rowreq_ctx->tbl_idx,
			rowreq_ctx->data.appParamsValueType,
			rowreq_ctx->data.appParamsTruthValue,
			rowreq_ctx->data.appParamsInteger32,
			rowreq_ctx->data.appParamsUnsigned32,
			rowreq_ctx->data.appParamsOctetString_len
			);

    /*
     * commit dessertAppParamsTable data
     * 1) check the column's flag in save_flags to see if it was set.
     * 2) clear the flag when you handle that column
     * 3) set the column's flag in column_set_flags if it needs undo
     *    processing in case of a failure.
     */
    if (save_flags & COLUMN_APPPARAMSTRUTHVALUE_FLAG) {
    	/* clear appParamsTruthValue */
        save_flags &= ~COLUMN_APPPARAMSTRUTHVALUE_FLAG;
        /*
         * commit column appParamsTruthValue.
         */

        appparam->bool = rowreq_ctx->data.appParamsTruthValue;

        rc = set(appparam);
        if (DESSERT_ERR == rc) {
            snmp_log(LOG_ERR,
                     "dessertAppParamsTable column appParamsTruthValue commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo appParamsTruthValue
             */
            rowreq_ctx->column_set_flags |=
                COLUMN_APPPARAMSTRUTHVALUE_FLAG;
        }
    }

    if (save_flags & COLUMN_APPPARAMSINTEGER32_FLAG) {
    	/* clear appParamsInteger32 */
        save_flags &= ~COLUMN_APPPARAMSINTEGER32_FLAG;
        /*
         * commit column appParamsInteger32.
         */

        appparam->int32 = rowreq_ctx->data.appParamsInteger32;

        rc = set(appparam);
        if (DESSERT_ERR == rc) {
            snmp_log(LOG_ERR,
                     "dessertAppParamsTable column appParamsInteger32 commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo appParamsInteger32
             */
            rowreq_ctx->column_set_flags |= COLUMN_APPPARAMSINTEGER32_FLAG;
        }
    }

    if (save_flags & COLUMN_APPPARAMSUNSIGNED32_FLAG) {
    	/* clear appParamsUnsigned32 */
        save_flags &= ~COLUMN_APPPARAMSUNSIGNED32_FLAG;
        /*
         * commit column appParamsUnsigned32.
         */

        appparam->uint32 = rowreq_ctx->data.appParamsUnsigned32;

        rc = set(appparam);
        if (DESSERT_ERR == rc) {
            snmp_log(LOG_ERR,
                     "dessertAppParamsTable column appParamsUnsigned32 commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo appParamsUnsigned32
             */
            rowreq_ctx->column_set_flags |=
                COLUMN_APPPARAMSUNSIGNED32_FLAG;
        }
    }

    if (save_flags & COLUMN_APPPARAMSOCTETSTRING_FLAG) {
    	/* clear appParamsOctetString */
        save_flags &= ~COLUMN_APPPARAMSOCTETSTRING_FLAG;
        /*
         * TODO:482:o: |-> commit column appParamsOctetString.
         */

        appparam->octetstring_len = rowreq_ctx->data.appParamsOctetString_len;
        appparam->octetstring = malloc(sizeof(char) * appparam->octetstring_len);
        memcpy(appparam->octetstring, rowreq_ctx->data.appParamsOctetString, rowreq_ctx->data.appParamsOctetString_len * sizeof(rowreq_ctx->data.appParamsOctetString[0]));

        rc = set(appparam);
        if (DESSERT_ERR == rc) {
            snmp_log(LOG_ERR,
                     "dessertAppParamsTable column appParamsOctetString commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo appParamsOctetString
             */
        	dessert_debug("dessertAppParamsTable column appParamsOctetString committed");
            rowreq_ctx->column_set_flags |=
                COLUMN_APPPARAMSOCTETSTRING_FLAG;
        }
    }

    if (rc == DESSERT_ERR) rc = -1; else {rc = MFD_SUCCESS;}

    /*
     * if we successfully committed this row, set the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags |= MFD_ROW_DIRTY;
    }

    if (save_flags) {
        snmp_log(LOG_ERR, "unhandled columns (0x%x) in commit\n",
                 save_flags);
        return MFD_ERROR;
    }

    _dessert_agentx_appparams_free(appparam);

    return rc;
}                               /* dessertAppParamsTable_commit */

/**
 * undo commit new values.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * dessertAppParamsTable_oids.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param dessertAppParamsTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
dessertAppParamsTable_undo_commit(dessertAppParamsTable_rowreq_ctx *
                                  rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_undo_commit", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:485:M: |-> Undo dessertAppParamsTable commit.
     * check the column's flag in rowreq_ctx->column_set_flags to see
     * if it was set during commit, then undo it.
     *
     * eg: if (rowreq_ctx->column_set_flags & COLUMN__FLAG) {}
     */


    /*
     * if we successfully un-committed this row, clear the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return rc;
}                               /* dessertAppParamsTable_undo_commit */

/*
 * TODO:440:M: Implement dessertAppParamsTable node value checks.
 * TODO:450:M: Implement dessertAppParamsTable undo functions.
 * TODO:460:M: Implement dessertAppParamsTable set functions.
 * TODO:480:M: Implement dessertAppParamsTable commit functions.
 */
/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsTruthValue
 * appParamsTruthValue is subid 5 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.5
 * Description:
A parameter with TruthValue semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 2/8. Values:  true(1), false(2)
 *
 * Its syntax is TruthValue (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsTruthValue_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * dessertAppParamsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  true(1), false(2)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
appParamsTruthValue_check_value(dessertAppParamsTable_rowreq_ctx *
                                rowreq_ctx, u_long appParamsTruthValue_val)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * Check for valid appParamsTruthValue value.
     */

    if (rowreq_ctx->data.appParamsValueType != DESSERT_APPPARAMS_VALUETYPE_BOOL) {

    	return MFD_NOT_VALID_EVER;
    } else {

    	return MFD_SUCCESS;         /* appParamsTruthValue value not illegal */
    }
}                               /* appParamsTruthValue_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * dessertAppParamsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
appParamsTruthValue_undo_setup(dessertAppParamsTable_rowreq_ctx *
                               rowreq_ctx)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup appParamsTruthValue undo.
     */
    /*
     * copy appParamsTruthValue data
     * set rowreq_ctx->undo->appParamsTruthValue from rowreq_ctx->data.appParamsTruthValue
     */
    rowreq_ctx->undo->appParamsTruthValue =
        rowreq_ctx->data.appParamsTruthValue;


    return MFD_SUCCESS;
}                               /* appParamsTruthValue_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param appParamsTruthValue_val
 *        A long containing the new value.
 */
int
appParamsTruthValue_set(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                        u_long appParamsTruthValue_val)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:245:o: |-> Implement appParamsTruthValue reverse mapping.
     * If the values for your data type don't exactly match the
     * possible values defined by the mib, you should map them here.
     */
    /*
     ***************************************************
     ***             START EXAMPLE CODE              ***
     ***---------------------------------------------***/
    switch (appParamsTruthValue_val) {
    case TRUTHVALUE_TRUE:
        rowreq_ctx->data.appParamsTruthValue =
            INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSTRUTHVALUE_TRUE;
        break;

    case TRUTHVALUE_FALSE:
        rowreq_ctx->data.appParamsTruthValue =
            INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSTRUTHVALUE_FALSE;
        break;

    default:
        snmp_log(LOG_ERR,
                 "couldn't reverse map value %ld for appParamsTruthValue\n",
                 appParamsTruthValue_val);
        return SNMP_ERR_GENERR;
    }
    /*
     ***---------------------------------------------***
     ***              END  EXAMPLE CODE              ***
     ***************************************************/

    return MFD_SUCCESS;
}                               /* appParamsTruthValue_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
appParamsTruthValue_undo(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up appParamsTruthValue undo.
     */
    /*
     * copy appParamsTruthValue data
     * set rowreq_ctx->data.appParamsTruthValue from rowreq_ctx->undo->appParamsTruthValue
     */
    rowreq_ctx->data.appParamsTruthValue =
        rowreq_ctx->undo->appParamsTruthValue;


    return MFD_SUCCESS;
}                               /* appParamsTruthValue_undo */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsInteger32
 * appParamsInteger32 is subid 6 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.6
 * Description:
A parameter with Integer32 semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsInteger32_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * dessertAppParamsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
appParamsInteger32_check_value(dessertAppParamsTable_rowreq_ctx *
                               rowreq_ctx, long appParamsInteger32_val)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsInteger32_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * Check for valid appParamsInteger32 value.
     */

    dessert_debug("check_value\n\t\trowreq_ctx->data.appParamsValueType [%d]",rowreq_ctx->data.appParamsValueType);
    if (rowreq_ctx->data.appParamsValueType != DESSERT_APPPARAMS_VALUETYPE_INT32) {

    	return MFD_NOT_VALID_EVER;
    } else {

		return MFD_SUCCESS; /* appParamsInteger32 value not illegal */
	}
}                               /* appParamsInteger32_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * dessertAppParamsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
appParamsInteger32_undo_setup(dessertAppParamsTable_rowreq_ctx *
                              rowreq_ctx)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsInteger32_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup appParamsInteger32 undo.
     */
    /*
     * copy appParamsInteger32 data
     * set rowreq_ctx->undo->appParamsInteger32 from rowreq_ctx->data.appParamsInteger32
     */
    rowreq_ctx->undo->appParamsInteger32 =
        rowreq_ctx->data.appParamsInteger32;


    return MFD_SUCCESS;
}                               /* appParamsInteger32_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param appParamsInteger32_val
 *        A long containing the new value.
 */
int
appParamsInteger32_set(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                       long appParamsInteger32_val)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsInteger32_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:245:o: |-> Implement appParamsInteger32 reverse mapping.
     * If the values for your data type don't exactly match the
     * possible values defined by the mib, you should map them here.
     */
    /*
     * TODO:461:M: |-> Set appParamsInteger32 value.
     * set appParamsInteger32 value in rowreq_ctx->data
     */
    rowreq_ctx->data.appParamsInteger32 = appParamsInteger32_val;


    return MFD_SUCCESS;
}                               /* appParamsInteger32_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
appParamsInteger32_undo(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsInteger32_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up appParamsInteger32 undo.
     */
    /*
     * copy appParamsInteger32 data
     * set rowreq_ctx->data.appParamsInteger32 from rowreq_ctx->undo->appParamsInteger32
     */
    rowreq_ctx->data.appParamsInteger32 =
        rowreq_ctx->undo->appParamsInteger32;


    return MFD_SUCCESS;
}                               /* appParamsInteger32_undo */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsUnsigned32
 * appParamsUnsigned32 is subid 7 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.7
 * Description:
A parameter with Unsigned32 semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsUnsigned32_val
 *        A u_long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * dessertAppParamsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_UNSIGNED
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
appParamsUnsigned32_check_value(dessertAppParamsTable_rowreq_ctx *
                                rowreq_ctx, u_long appParamsUnsigned32_val)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsUnsigned32_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid appParamsUnsigned32 value.
     */
    if (rowreq_ctx->data.appParamsValueType != DESSERT_APPPARAMS_VALUETYPE_UINT32) {

    	return MFD_NOT_VALID_EVER;
	} else {

		return MFD_SUCCESS;         /* appParamsUnsigned32 value not illegal */
	}
}                               /* appParamsUnsigned32_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * dessertAppParamsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
appParamsUnsigned32_undo_setup(dessertAppParamsTable_rowreq_ctx *
                               rowreq_ctx)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsUnsigned32_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup appParamsUnsigned32 undo.
     */
    /*
     * copy appParamsUnsigned32 data
     * set rowreq_ctx->undo->appParamsUnsigned32 from rowreq_ctx->data.appParamsUnsigned32
     */
    rowreq_ctx->undo->appParamsUnsigned32 =
        rowreq_ctx->data.appParamsUnsigned32;


    return MFD_SUCCESS;
}                               /* appParamsUnsigned32_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param appParamsUnsigned32_val
 *        A u_long containing the new value.
 */
int
appParamsUnsigned32_set(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                        u_long appParamsUnsigned32_val)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsUnsigned32_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:245:o: |-> Implement appParamsUnsigned32 reverse mapping.
     * If the values for your data type don't exactly match the
     * possible values defined by the mib, you should map them here.
     */
    /*
     * TODO:461:M: |-> Set appParamsUnsigned32 value.
     * set appParamsUnsigned32 value in rowreq_ctx->data
     */
    rowreq_ctx->data.appParamsUnsigned32 = appParamsUnsigned32_val;


    return MFD_SUCCESS;
}                               /* appParamsUnsigned32_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
appParamsUnsigned32_undo(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsUnsigned32_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up appParamsUnsigned32 undo.
     */
    /*
     * copy appParamsUnsigned32 data
     * set rowreq_ctx->data.appParamsUnsigned32 from rowreq_ctx->undo->appParamsUnsigned32
     */
    rowreq_ctx->data.appParamsUnsigned32 =
        rowreq_ctx->undo->appParamsUnsigned32;


    return MFD_SUCCESS;
}                               /* appParamsUnsigned32_undo */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsOctetString
 * appParamsOctetString is subid 9 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.9
 * Description:
A parameter containing of up to 1024 octets.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   1
 *   hint: 1024a
 *
 * Ranges:  0 - 1024;
 *
 * Its syntax is DessertApplicationOctetString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 1024)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsOctetString_val_ptr
 *        A char containing the new value.
 * @param appParamsOctetString_val_ptr_len
 *        The size (in bytes) of the data pointed to by appParamsOctetString_val_ptr
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * dessertAppParamsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_OCTET_STR
 *    The length is < sizeof(rowreq_ctx->data.appParamsOctetString).
 *    The length is in (one of) the range set(s):  0 - 1024
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
appParamsOctetString_check_value(dessertAppParamsTable_rowreq_ctx *
                                 rowreq_ctx,
                                 char *appParamsOctetString_val_ptr,
                                 size_t appParamsOctetString_val_ptr_len)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsOctetString_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != appParamsOctetString_val_ptr);

    /*
     * TODO:441:o: |-> Check for valid appParamsOctetString value.
     */
    if (rowreq_ctx->data.appParamsValueType != DESSERT_APPPARAMS_VALUETYPE_OCTETSTRING) {

    	return MFD_NOT_VALID_EVER;
	} else {

		return MFD_SUCCESS;         /* appParamsOctetString value not illegal */
	}
}                               /* appParamsOctetString_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (dessertAppParamsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * dessertAppParamsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
appParamsOctetString_undo_setup(dessertAppParamsTable_rowreq_ctx *
                                rowreq_ctx)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsOctetString_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup appParamsOctetString undo.
     */
    /*
     * copy appParamsOctetString and appParamsOctetString_len data
     * set rowreq_ctx->undo->appParamsOctetString from rowreq_ctx->data.appParamsOctetString
     */
    memcpy(rowreq_ctx->undo->appParamsOctetString,
           rowreq_ctx->data.appParamsOctetString,
           (rowreq_ctx->data.appParamsOctetString_len *
            sizeof(rowreq_ctx->undo->appParamsOctetString[0])));
    rowreq_ctx->undo->appParamsOctetString_len =
        rowreq_ctx->data.appParamsOctetString_len;


    return MFD_SUCCESS;
}                               /* appParamsOctetString_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param appParamsOctetString_val_ptr
 *        A char containing the new value.
 * @param appParamsOctetString_val_ptr_len
 *        The size (in bytes) of the data pointed to by appParamsOctetString_val_ptr
 */
int
appParamsOctetString_set(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                         char *appParamsOctetString_val_ptr,
                         size_t appParamsOctetString_val_ptr_len)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsOctetString_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != appParamsOctetString_val_ptr);

    /*
     * TODO:245:o: |-> Implement appParamsOctetString reverse mapping.
     * If the values for your data type don't exactly match the
     * possible values defined by the mib, you should map them here.
     */
    /*
     * TODO:461:M: |-> Set appParamsOctetString value.
     * set appParamsOctetString value in rowreq_ctx->data
     */
    memcpy(rowreq_ctx->data.appParamsOctetString,
           appParamsOctetString_val_ptr, appParamsOctetString_val_ptr_len);
    /** convert bytes to number of char */
    rowreq_ctx->data.appParamsOctetString_len =
        appParamsOctetString_val_ptr_len /
        sizeof(appParamsOctetString_val_ptr[0]);


    return MFD_SUCCESS;
}                               /* appParamsOctetString_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
appParamsOctetString_undo(dessertAppParamsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsOctetString_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up appParamsOctetString undo.
     */
    /*
     * copy appParamsOctetString and appParamsOctetString_len data
     * set rowreq_ctx->data.appParamsOctetString from rowreq_ctx->undo->appParamsOctetString
     */
    memcpy(rowreq_ctx->data.appParamsOctetString,
           rowreq_ctx->undo->appParamsOctetString,
           (rowreq_ctx->undo->appParamsOctetString_len *
            sizeof(rowreq_ctx->data.appParamsOctetString[0])));
    rowreq_ctx->data.appParamsOctetString_len =
        rowreq_ctx->undo->appParamsOctetString_len;


    return MFD_SUCCESS;
}                               /* appParamsOctetString_undo */

/** @} */
