#include <string.h>
#include <ctype.h>

#include <config.h>

#include "e-date-rfc.h"

static gint e_date_rfc_strmonth_short (const gchar * a_month);
extern long timezone;

time_t e_date_rfc_parse (const gchar * a_date) {
  struct tm l_tm_time;
  gboolean borken = FALSE;
  gint i = 0;
  g_return_val_if_fail (a_date != NULL, -1);

  tzset ();

  memset (&l_tm_time, 0, sizeof (struct tm));
  if (a_date[3] != ',') {
    return -1;
  }

  if (((strlen (a_date) != 29)) && (strlen (a_date) != 27)) {
    return -1;
  }
  if (strlen (a_date) == 27) {
    i = 2;
  }

  if (a_date[4] != ' ') {
    return -1;
  }

  /* Day */
  if ((isdigit (a_date[5]) == 0) || (isdigit (a_date[6]) == 0)) {
    return -1;
  } else {
    l_tm_time.tm_mday += (a_date[5] - 0x30) * 10;
    l_tm_time.tm_mday += (a_date[6] - 0x30);
  }

  /* Month */
  if ((l_tm_time.tm_mon = e_date_rfc_strmonth_short (&a_date[8])) < 0) {
    return -1;
  }

  /* Year */
  if ((isdigit (a_date[12]) == 0) ||
      (isdigit (a_date[13]) == 0) ||
      (isdigit (a_date[14 - i]) == 0) ||
      (isdigit (a_date[15 - i]) == 0)) {
    return -1;
  } else {
    l_tm_time.tm_year += (i * 1000);
    if (i == 0) {
      l_tm_time.tm_year += (a_date[12] - 0x30) * 1000;
      l_tm_time.tm_year += (a_date[13] - 0x30) * 100;
    }
    l_tm_time.tm_year += (a_date[14 - i] - 0x30) * 10;
    l_tm_time.tm_year += (a_date[15 - i] - 0x30);
    l_tm_time.tm_year -= 1900;    
  }

  if (a_date[16 - i] != ' ') {
    return -1;
  }

  /* Time */
  if ((isdigit (a_date[17 - i]) == 0) ||
      (isdigit (a_date[18 - i]) == 0) ||
      (a_date[19 - i] != ':') ||
      (isdigit (a_date[20 - i]) == 0) ||
      (isdigit (a_date[21 - i]) == 0) ||
      (a_date[22 - i] != ':') ||
      (isdigit (a_date[23 - i]) == 0) ||
      (isdigit (a_date[24 - i]) == 0)) {
    return -1;
  } else {
    l_tm_time.tm_hour += (a_date[17 - i] - 0x30) * 10 - (timezone / 3600);
    l_tm_time.tm_hour += (a_date[18 - i] - 0x30);
    l_tm_time.tm_min  += (a_date[20 - i] - 0x30) * 10;
    l_tm_time.tm_min  += (a_date[21 - i] - 0x30);
    l_tm_time.tm_sec  += (a_date[23 - i] - 0x30) * 10;
    l_tm_time.tm_sec  += (a_date[24 - i] - 0x30);
  }

  if (a_date[25 - i] != ' ') {
    return -1;
  }

  if (strncmp (&a_date[26 - i], "GMT", 3) != 0) {
    return -1;
  }

  return mktime (&l_tm_time);
}

static gint e_date_rfc_strmonth_short (const gchar * a_month) {
  if (strncmp (a_month, "Jan", 3) == 0) {
    return 0;
  } else if (strncmp (a_month, "Feb", 3) == 0) {
    return 1;
  } else if (strncmp (a_month, "Mar", 3) == 0) {
    return 2;
  } else if (strncmp (a_month, "Apr", 3) == 0) {
    return 3;
  } else if (strncmp (a_month, "May", 3) == 0) {
    return 4;
  } else if (strncmp (a_month, "Jun", 3) == 0) {
    return 5;
  } else if (strncmp (a_month, "Jul", 3) == 0) {
    return 6;
  } else if (strncmp (a_month, "Aug", 3) == 0) {
    return 7;
  } else if (strncmp (a_month, "Sep", 3) == 0) {
    return 8;
  } else if (strncmp (a_month, "Oct", 3) == 0) {
    return 9;
  } else if (strncmp (a_month, "Nov", 3) == 0) {
    return 10;
  } else if (strncmp (a_month, "Dec", 3) == 0) {
    return 11;
  }

  /* not a valid date */
  return -1;
}
