/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBIMAGEMANAGER_H
#define INCLUDED_EPUBIMAGEMANAGER_H

#include <unordered_map>

#include <librevenge/librevenge.h>

#include "EPUBCounter.h"
#include "EPUBPath.h"

namespace libepubgen
{

class EPUBManifest;
class EPUBPackage;

class EPUBImageManager
{
  // disable copying
  EPUBImageManager(const EPUBImageManager &);
  EPUBImageManager &operator=(const EPUBImageManager &);

  struct BinaryDataHash // : public std::unary_function<librevenge::RVNGBinaryData, std::size_t>
  {
    std::size_t operator()(const librevenge::RVNGBinaryData &data) const;
  };

  struct BinaryDataEqual // : public std::binary_function<librevenge::RVNGBinaryData, librevenge::RVNGBinaryData, bool>
  {
    bool operator()(const librevenge::RVNGBinaryData &left, const librevenge::RVNGBinaryData &right) const;
  };

  typedef std::unordered_map<librevenge::RVNGBinaryData, EPUBPath, BinaryDataHash, BinaryDataEqual> MapType_t;

public:
  explicit EPUBImageManager(EPUBManifest &manifest);

  const EPUBPath &insert(const librevenge::RVNGBinaryData &data, const librevenge::RVNGString &mimetype);

  void writeTo(EPUBPackage &package);

private:
  EPUBManifest &m_manifest;
  MapType_t m_map;
  EPUBCounter m_number;
};

}

#endif // INCLUDED_EPUBIMAGEMANAGER

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
