/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBTABLESTYLEMANAGER_H
#define INCLUDED_EPUBTABLESTYLEMANAGER_H

#include <librevenge/librevenge.h>

#include <string>
#include <unordered_map>
#include <vector>

#include <boost/functional/hash.hpp>

#include "EPUBCSSProperties.h"

namespace libepubgen
{

class EPUBCSSSink;

/** Small class to manage the tables style */
class EPUBTableStyleManager
{
  typedef std::unordered_map<EPUBCSSProperties, std::string, boost::hash<EPUBCSSProperties>> ContentNameMap_t;

public:
  //! constructor
  EPUBTableStyleManager() : m_cellContentNameMap(), m_rowContentNameMap(), m_columWitdhsStack()
  {
  }
  //! destructor
  ~EPUBTableStyleManager()
  {
  }
  //! open a table
  void openTable(librevenge::RVNGPropertyListVector const &colList);
  //! close a table
  void closeTable();
  //! returns the class name corresponding to a propertylist
  std::string getCellClass(librevenge::RVNGPropertyList const &pList);
  //! returns the class name corresponding to a propertylist
  std::string getRowClass(librevenge::RVNGPropertyList const &pList);
  //! send the data to the sink
  void send(EPUBCSSSink &out);
private:
  //! convert a property list into a CSS property map
  void extractCellProperties(librevenge::RVNGPropertyList const &pList, EPUBCSSProperties &cssProps) const;
  //! convert a property list into a CSS property map
  void extractRowProperties(librevenge::RVNGPropertyList const &pList, EPUBCSSProperties &cssProps) const;
  //! try to return the col width
  bool getColumnsWidth(int i, int numSpanned, double &w) const;
  //! a map cell content -> name
  ContentNameMap_t m_cellContentNameMap;
  //! a map row content -> name
  ContentNameMap_t m_rowContentNameMap;
  //! a stack of column width (in inches )
  std::vector<std::vector<double> > m_columWitdhsStack;

  EPUBTableStyleManager(EPUBTableStyleManager const &orig);
  EPUBTableStyleManager operator=(EPUBTableStyleManager const &orig);
};

}

#endif

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
