/*
 * The internal definitions
 *
 * Copyright (c) 2008-2009, Joachim Metz <forensics@hoffmannbv.nl>,
 * Hoffmann Investigations.
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBUNA_INTERNAL_DEFINITIONS_H )
#define _LIBUNA_INTERNAL_DEFINITIONS_H

#include <common.h>

/* Define HAVE_LOCAL_LIBUNA for local use of libuna
 */
#if !defined( HAVE_LOCAL_LIBUNA )
#include <libuna/definitions.h>

/* The definitions in <libuna/definitions.h> are copied here
 * for local use of libuna
 */
#else
#include <byte_stream.h>

#define LIBUNA_VERSION					20091031

/* The libuna version string
 */
#define LIBUNA_VERSION_STRING				"20091031"

/* The endian definitions
 */
#define	LIBUNA_ENDIAN_BIG                               _BYTE_STREAM_ENDIAN_BIG
#define	LIBUNA_ENDIAN_LITTLE                            _BYTE_STREAM_ENDIAN_LITTLE

/* The codepage definitions
 */
enum LIBUNA_CODEPAGE
{
	LIBUNA_CODEPAGE_ASCII				= 20127,

	LIBUNA_CODEPAGE_ISO_8859_1			= 28591,
	LIBUNA_CODEPAGE_ISO_8859_2			= 28592,
	LIBUNA_CODEPAGE_ISO_8859_3			= 28593,
	LIBUNA_CODEPAGE_ISO_8859_4			= 28594,
	LIBUNA_CODEPAGE_ISO_8859_5			= 28595,
	LIBUNA_CODEPAGE_ISO_8859_6			= 28596,
	LIBUNA_CODEPAGE_ISO_8859_7			= 28597,
	LIBUNA_CODEPAGE_ISO_8859_8			= 28598,
	LIBUNA_CODEPAGE_ISO_8859_9			= 28599,
	LIBUNA_CODEPAGE_ISO_8859_10			= 28600,
	LIBUNA_CODEPAGE_ISO_8859_11			= 28601,
	LIBUNA_CODEPAGE_ISO_8859_13			= 28603,
	LIBUNA_CODEPAGE_ISO_8859_14			= 28604,
	LIBUNA_CODEPAGE_ISO_8859_15			= 28605,
	LIBUNA_CODEPAGE_ISO_8859_16			= 28606,

	LIBUNA_CODEPAGE_KOI8_R				= 20866,
	LIBUNA_CODEPAGE_KOI8_U				= 21866,

	LIBUNA_CODEPAGE_WINDOWS_874			= 874,
	LIBUNA_CODEPAGE_WINDOWS_1250			= 1250,
	LIBUNA_CODEPAGE_WINDOWS_1251			= 1251,
	LIBUNA_CODEPAGE_WINDOWS_1252			= 1252,
	LIBUNA_CODEPAGE_WINDOWS_1253			= 1253,
	LIBUNA_CODEPAGE_WINDOWS_1254			= 1254,
	LIBUNA_CODEPAGE_WINDOWS_1255			= 1255,
	LIBUNA_CODEPAGE_WINDOWS_1256			= 1256,
	LIBUNA_CODEPAGE_WINDOWS_1257			= 1257,
	LIBUNA_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBUNA_CODEPAGE_US_ASCII			LIBUNA_CODEPAGE_ASCII

#define LIBUNA_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBUNA_CODEPAGE_ISO_8859_1
#define LIBUNA_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBUNA_CODEPAGE_ISO_8859_2
#define LIBUNA_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBUNA_CODEPAGE_ISO_8859_3
#define LIBUNA_CODEPAGE_ISO_NORTH_EUROPEAN		LIBUNA_CODEPAGE_ISO_8859_4
#define LIBUNA_CODEPAGE_ISO_CYRILLIC			LIBUNA_CODEPAGE_ISO_8859_5
#define LIBUNA_CODEPAGE_ISO_ARABIC			LIBUNA_CODEPAGE_ISO_8859_6
#define LIBUNA_CODEPAGE_ISO_GREEK			LIBUNA_CODEPAGE_ISO_8859_7
#define LIBUNA_CODEPAGE_ISO_HEBREW			LIBUNA_CODEPAGE_ISO_8859_8
#define LIBUNA_CODEPAGE_ISO_TURKISH			LIBUNA_CODEPAGE_ISO_8859_9
#define LIBUNA_CODEPAGE_ISO_NORDIC			LIBUNA_CODEPAGE_ISO_8859_10
#define LIBUNA_CODEPAGE_ISO_THAI			LIBUNA_CODEPAGE_ISO_8859_11
#define LIBUNA_CODEPAGE_ISO_BALTIC			LIBUNA_CODEPAGE_ISO_8859_13
#define LIBUNA_CODEPAGE_ISO_CELTIC			LIBUNA_CODEPAGE_ISO_8859_14

#define LIBUNA_CODEPAGE_ISO_LATIN_1			LIBUNA_CODEPAGE_ISO_8859_1
#define LIBUNA_CODEPAGE_ISO_LATIN_2			LIBUNA_CODEPAGE_ISO_8859_2
#define LIBUNA_CODEPAGE_ISO_LATIN_3			LIBUNA_CODEPAGE_ISO_8859_3
#define LIBUNA_CODEPAGE_ISO_LATIN_4			LIBUNA_CODEPAGE_ISO_8859_4
#define LIBUNA_CODEPAGE_ISO_LATIN_5			LIBUNA_CODEPAGE_ISO_8859_9
#define LIBUNA_CODEPAGE_ISO_LATIN_6			LIBUNA_CODEPAGE_ISO_8859_10
#define LIBUNA_CODEPAGE_ISO_LATIN_7			LIBUNA_CODEPAGE_ISO_8859_13
#define LIBUNA_CODEPAGE_ISO_LATIN_8			LIBUNA_CODEPAGE_ISO_8859_14
#define LIBUNA_CODEPAGE_ISO_LATIN_9			LIBUNA_CODEPAGE_ISO_8859_15
#define LIBUNA_CODEPAGE_ISO_LATIN_10			LIBUNA_CODEPAGE_ISO_8859_16

#define LIBUNA_CODEPAGE_KOI8_RUSSIAN			LIBUNA_CODEPAGE_KOI8_R
#define LIBUNA_CODEPAGE_KOI8_UKRAINIAN			LIBUNA_CODEPAGE_KOI8_U

#define LIBUNA_CODEPAGE_WINDOWS_THAI			LIBUNA_CODEPAGE_WINDOWS_874
#define LIBUNA_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBUNA_CODEPAGE_WINDOWS_1250
#define LIBUNA_CODEPAGE_WINDOWS_CYRILLIC		LIBUNA_CODEPAGE_WINDOWS_1251
#define LIBUNA_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBUNA_CODEPAGE_WINDOWS_1252
#define LIBUNA_CODEPAGE_WINDOWS_GREEK			LIBUNA_CODEPAGE_WINDOWS_1253
#define LIBUNA_CODEPAGE_WINDOWS_TURKISH			LIBUNA_CODEPAGE_WINDOWS_1254
#define LIBUNA_CODEPAGE_WINDOWS_HEBREW			LIBUNA_CODEPAGE_WINDOWS_1255
#define LIBUNA_CODEPAGE_WINDOWS_ARABIC			LIBUNA_CODEPAGE_WINDOWS_1256
#define LIBUNA_CODEPAGE_WINDOWS_BALTIC			LIBUNA_CODEPAGE_WINDOWS_1257
#define LIBUNA_CODEPAGE_WINDOWS_VIETNAMESE		LIBUNA_CODEPAGE_WINDOWS_1258

#endif

/* Character definitions
 */
#define LIBUNA_UNICODE_REPLACEMENT_CHARACTER		0x0000fffdUL
#define LIBUNA_UNICODE_BASIC_MULTILINGUAL_PLANE_MAX	0x0000ffffUL
#define LIBUNA_UNICODE_SURROGATE_LOW_RANGE_START	0x0000dc00UL
#define LIBUNA_UNICODE_SURROGATE_LOW_RANGE_END		0x0000dfffUL
#define LIBUNA_UNICODE_SURROGATE_HIGH_RANGE_START	0x0000d800UL
#define LIBUNA_UNICODE_SURROGATE_HIGH_RANGE_END		0x0000dbffUL
#define LIBUNA_UNICODE_CHARACTER_MAX			0x0010ffffUL

#define LIBUNA_UTF16_CHARACTER_MAX			0x0010ffffUL
#define LIBUNA_UTF32_CHARACTER_MAX			0x7fffffffUL

#define LIBUNA_ASCII_REPLACEMENT_CHARACTER		0x1a

/* UTF-7 definitions
 */
#define	LIBUNA_UTF7_IS_BASE64_ENCODED			0x80000000UL

#endif

