#include <iostream>
#include <string>

#define FACTORY_DFLT_KEYTYPE std::string

#include <factory++/factory++.hpp>

struct A
{
  int x;
  inline A(int const X = 0) : x(X) { std::cout << "A(" << x << ") "; }
  inline virtual ~A() { std::cout << "~A() "; }
  virtual void fn() const { std::cout << "A::fn(), x=" << x << std::endl; }
};

FACTORY_REGISTER_CLASS(A, A, "A");

struct AA : public A
{
  inline AA(int const X = 0) : A(X) { std::cout << "AA(" << x << ") "; }
  inline virtual ~AA() { std::cout << "~AA() "; }
  virtual void fn() const { std::cout << "AA::fn(), x=" << x << std::endl; }
};

FACTORY_REGISTER_CLASS(A, AA, "AA");

struct B
{
  int x;
  inline B(int const X = 0) : x(X) { std::cout << "B(" << x << ") "; }
  inline virtual ~B() { std::cout << "~B() "; }
  virtual void fn() const { std::cout << "B::fn(), x=" << x << std::endl; }
};

struct AA_constructor : public Factory::Constructor<AA>
{
  int x;

  inline AA_constructor(int const X = 0) : x(X) {}

  inline AA* operator()(AA* a)
  {
    std::cout << "\nnon-const custom constructor called: ";  
    return new (a) AA(++x);
  }

  inline AA* operator()(AA* a) const {
    std::cout << "\nconst custom constructor called: ";  
    return new (a) AA(x);
  }
};

int main(void)
{
  typedef Factory::Factory<A, std::string> _Fac;

  A* a; A* b;

  // instantiate with default constructor, x = 0
  a = _Fac::create(_Fac::make_construction_request("AA"));
  b = _Fac::create("A");
  std::cout << std::endl;
  a->fn(); b->fn();
  _Fac::destroy("A", b);
  _Fac::destroy(_Fac::make_destruction_request("AA"), a);
  std::cout << std::endl;

  // instantiate with non-const custom constructor, x = 15, 16
  AA_constructor c1(14);
  a = _Fac::create(_Fac::make_construction_request("AA", c1));
  b = _Fac::create("AA", c1);
  std::cout << std::endl;
  a->fn(); b->fn();
  // default destructor, i don't know yet what custom destructors would be for
  _Fac::destroy("AA", b);
  _Fac::destroy(_Fac::make_destruction_request("AA"), a);
  std::cout << std::endl;

  //instantiate with const custom constructor, x = 7, 8
  a = _Fac::create(_Fac::make_construction_request("AA", AA_constructor(7)));
  b = _Fac::create("AA", AA_constructor(8));
  std::cout << std::endl;
  a->fn(); b->fn();
  // default destructor, i don't know yet what custom destructors would be for
  _Fac::destroy("AA", b);
  _Fac::destroy(_Fac::make_destruction_request("AA"), a);
  std::cout << std::endl;

  //instantiate with copy constructor, x = 5
  std::cout << std::endl;
  AA a1; a1.x = 5;
  a = _Fac::create("AA", a1);
  std::cout << std::endl;
  a->fn();
  // default destructor, i don't know yet what custom destructors would be for
  _Fac::destroy("AA", a);
  std::cout << std::endl;

  return 0;
}

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
