package net.styx.flux.comm;

import java.net.*;
import java.io.*;
import java.util.*;

    
public class TTree {
    
    byte token[];
    Vector children;
    int datasize;
    int serial;
    short transid;
    short flags;
    
    TTree() {
	
	token = null;
	datasize = 0;
	children = new Vector();
    }
    
    TTree(int datasize, int serial, short transid, short flags, DataInputStream in) {
	token = null;
	this.datasize = datasize;
	this.serial = serial;
	this.transid = transid;
	this.flags = flags;
	
	children = new Vector();
	
	try {

	    datasize = in.readInt();
	    
	    int childcount = in.readInt();
	    
	    if (datasize != 0) {
		token = new byte[datasize];
		in.readFully(token);
	    }
	    
	    for(int i = childcount ; i > 0 ; i-- ) {
		children.addElement(new TTree(0, serial, transid, flags, in));
	    }
	    
	} catch (Exception e) {
	    System.exit(0);
	}
    }

    public synchronized byte[] getToken() {
	return token;
    }

    public synchronized void setToken(byte[] token) { 
	this.token = token;
    }

    public synchronized int getTokenLength() {
	if (token != null) {
	return token.length;
	} else {
	    return 0;
	}
    }

    public synchronized int getChildCount() {
	return children.size();
    }

    public synchronized TTree getChildAt(int i) {
	return (TTree)children.elementAt(i);
    }

    public synchronized void delChildAt(int i) {
	children.removeElementAt(i);
    }

    public synchronized void addChild(TTree newchild) {
	children.addElement(newchild);
    }

    public synchronized int getDatasize() {
	return datasize;
    }

}
