/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


char *_url_chars_allowed = "abcdefghijklmnopqrstuvwxyz"
                           "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                           "0123456789.,/?=@_-+&#";


char *url_esc_to_8bit(char *esc_str)
{
  char *flat_str, *p0, *p1;
  
  flat_str = malloc(strlen(esc_str) + 1);
  for (p0 = esc_str, p1 = flat_str; *p0; p1++)
  {
    if (*p0 == '%')
    {
      p0++;
      if (!p0) break;
      if (isalpha(*p0)) *p1 = (tolower(*p0) - 'a' + 10) << 4;
      else *p1 = (*p0 - '0') << 4;
      p0++;
      if (!p0) break;
      if (isalpha(*p0)) *p1 |= tolower(*p0) - 'a' + 10;
      else *p1 |= *p0 - '0';
      p0++;
    }
    else *p1 = *(p0++);
  }

  *p1 = 0;
  flat_str = realloc(flat_str, strlen(flat_str) + 1);
  return(flat_str);
}


char *url_8bit_to_esc(char *flat_str)
{
  char *esc_str, *p0, *p1;

  esc_str = malloc(strlen(flat_str) * 3 + 1);
  for (p0 = flat_str, p1 = esc_str; *p0; p0++)
  {
    if (!index(_url_chars_allowed, *p0))
    {
      *(p1++) = '%';
      *(p1++) = (*p0 >> 4) < 10 ? '0' + (*p0 >> 4) : 'a' + (*p0 >> 4) - 10;
      *(p1++) = (*p0 & 0x0f) < 10 ? '0' + (*p0 & 0x0f) : 'a' + (*p0 & 0x0f) - 10;
    }
    else *(p1++) = *p0;
  }
  
  *p1 = 0;
  esc_str = realloc(esc_str, strlen(esc_str) + 1);
  return(esc_str);
}
